/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.search.domain;

import com.atlassian.bitbucket.search.domain.Avatar;
import com.atlassian.bitbucket.search.domain.Identifier;
import com.atlassian.bitbucket.search.domain.Project;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class SimpleProject
implements Project {
    private final Identifier<Project> id;
    private final String key;
    private final String name;
    private final boolean isPublic;
    private Optional<Avatar> avatar;

    private SimpleProject(Builder builder) {
        this.id = Objects.requireNonNull(builder.id, "builder.id");
        this.key = Objects.requireNonNull(builder.key, "builder.key");
        this.name = Objects.requireNonNull(builder.name, "builder.name");
        this.avatar = Objects.requireNonNull(builder.avatar, "builder.avatar");
        this.isPublic = builder.isPublic;
    }

    @Override
    public Identifier<Project> getId() {
        return this.id;
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public Optional<Avatar> getAvatar() {
        return this.avatar;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isPublic() {
        return this.isPublic;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SimpleProject that = (SimpleProject)o;
        return this.isPublic == that.isPublic && Objects.equals(this.id, that.id) && Objects.equals(this.key, that.key) && Objects.equals(this.name, that.name) && Objects.equals(this.avatar, that.avatar);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.key, this.name, this.isPublic, this.avatar);
    }

    public String toString() {
        return "SimpleProject{id=" + this.id + ", key='" + this.key + '\'' + ", name='" + this.name + '\'' + ", isPublic=" + this.isPublic + ", avatar=" + this.avatar + '}';
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Identifier<Project> id;
        private String name;
        private String key;
        private boolean isPublic;
        private Optional<Avatar> avatar = Optional.empty();

        private Builder() {
        }

        @Nonnull
        public Builder avatar(@Nonnull Optional<Avatar> avatar) {
            this.avatar = Objects.requireNonNull(avatar, "avatar");
            return this;
        }

        @Nonnull
        public Builder avatar(@Nullable Avatar avatar) {
            this.avatar = Optional.ofNullable(avatar);
            return this;
        }

        @Nonnull
        public Builder isPublic(boolean isPublic) {
            this.isPublic = isPublic;
            return this;
        }

        @Nonnull
        public Builder id(@Nonnull Identifier<Project> id) {
            this.id = Objects.requireNonNull(id, "id");
            return this;
        }

        @Nonnull
        public Builder key(@Nonnull String key) {
            this.key = Objects.requireNonNull(key, "key");
            return this;
        }

        @Nonnull
        public Builder name(@Nonnull String name) {
            this.name = Objects.requireNonNull(name, "name");
            return this;
        }

        @Nonnull
        public SimpleProject build() {
            return new SimpleProject(this);
        }
    }
}

