/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.search.domain;

import com.atlassian.bitbucket.search.domain.Avatar;
import com.atlassian.bitbucket.search.domain.AvatarType;
import java.util.Objects;
import javax.annotation.Nonnull;

public class SimpleAvatar
implements Avatar {
    private AvatarType avatarType;
    private String avatarData;

    private SimpleAvatar(Builder builder) {
        this.avatarType = Objects.requireNonNull(builder.avatarType, "avatarType");
        this.avatarData = Objects.requireNonNull(builder.avatarData, "avatarData");
    }

    @Override
    @Nonnull
    public AvatarType getType() {
        return this.avatarType;
    }

    @Override
    @Nonnull
    public String getData() {
        return this.avatarData;
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SimpleAvatar)) {
            return false;
        }
        SimpleAvatar that = (SimpleAvatar)o;
        return this.avatarType == that.avatarType && Objects.equals(this.avatarData, that.avatarData);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.avatarType, this.avatarData});
    }

    public String toString() {
        return "SimpleAvatar{type=" + (Object)((Object)this.avatarType) + ", data=" + this.avatarData + "}";
    }

    public static final class Builder {
        private AvatarType avatarType;
        private String avatarData;

        public Builder avatarType(@Nonnull AvatarType avatarType) {
            this.avatarType = Objects.requireNonNull(avatarType, "avatarType");
            return this;
        }

        public Builder avatarData(@Nonnull String avatarData) {
            this.avatarData = Objects.requireNonNull(avatarData, "avatarData");
            return this;
        }

        public SimpleAvatar build() {
            return new SimpleAvatar(this);
        }
    }
}

