/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.xcode.keychain;

import com.atlassian.bamboo.build.logger.BuildLogger;
import com.atlassian.bamboo.build.logger.LogInterceptor;
import com.atlassian.bamboo.build.logger.interceptors.ErrorMemorisingInterceptor;
import com.atlassian.bamboo.configuration.ConfigurationMap;
import com.atlassian.bamboo.process.ExternalProcessBuilder;
import com.atlassian.bamboo.process.ProcessService;
import com.atlassian.bamboo.task.CommonTaskContext;
import com.atlassian.bamboo.task.TaskContext;
import com.atlassian.bamboo.task.TaskException;
import com.atlassian.bamboo.task.TaskResult;
import com.atlassian.bamboo.task.TaskResultBuilder;
import com.atlassian.bamboo.task.TaskState;
import com.atlassian.bamboo.task.TaskType;
import com.atlassian.utils.process.ExternalProcess;
import com.atlassian.utils.process.ProcessHandler;
import com.atlassian.utils.process.StringProcessHandler;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.jetbrains.annotations.NotNull;

public class UnlockKeychainTaskType
implements TaskType {
    private static final String SECURITY_UTIL_PATH = "/usr/bin/security";
    private static final String KEYCHAIN_EXT = ".keychain";
    private final ProcessService processService;

    public UnlockKeychainTaskType(ProcessService processService) {
        this.processService = processService;
    }

    @NotNull
    public TaskResult execute(@NotNull TaskContext taskContext) throws TaskException {
        ArrayList command;
        TaskResultBuilder resultBuilder = TaskResultBuilder.newBuilder((CommonTaskContext)taskContext);
        ErrorMemorisingInterceptor errorLines = ErrorMemorisingInterceptor.newInterceptor();
        BuildLogger buildLogger = taskContext.getBuildLogger();
        buildLogger.getInterceptorStack().add((LogInterceptor)errorLines);
        ConfigurationMap configurationMap = taskContext.getConfigurationMap();
        File workingDirectory = taskContext.getWorkingDirectory();
        String password = (String)configurationMap.get((Object)"password");
        String keychain = (String)configurationMap.get((Object)"keychain");
        if (!new File(keychain).exists() && !keychain.endsWith(KEYCHAIN_EXT)) {
            keychain = keychain + KEYCHAIN_EXT;
        }
        if (configurationMap.getAsBoolean("setAsDefaultKeychain")) {
            command = Lists.newArrayList((Object[])new String[]{SECURITY_UTIL_PATH, "default-keychain", "-s", keychain});
            resultBuilder.checkReturnCode(this.processService.executeExternalProcess((CommonTaskContext)taskContext, new ExternalProcessBuilder().command((List)command).workingDirectory(workingDirectory)));
            if (resultBuilder.getTaskState() != TaskState.SUCCESS) {
                return resultBuilder.build();
            }
        }
        buildLogger.addBuildLogEntry("Unlocking keychain '" + keychain + "'");
        command = Lists.newArrayList((Object[])new String[]{SECURITY_UTIL_PATH, "unlock-keychain", "-p", password, keychain});
        StringProcessHandler handler = new StringProcessHandler();
        handler.setThrowOnNonZeroExit(false);
        ExternalProcess externalProcess = new com.atlassian.utils.process.ExternalProcessBuilder().command((List)command).handler((ProcessHandler)handler).build();
        externalProcess.execute();
        String error = handler.getError();
        if (StringUtils.isNotEmpty((String)error)) {
            buildLogger.addErrorLogEntry(error);
        }
        return TaskResultBuilder.newBuilder((CommonTaskContext)taskContext).checkReturnCode(externalProcess).build();
    }
}

