/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.xcode.keychain;

import com.atlassian.bamboo.collections.ActionParametersMap;
import com.atlassian.bamboo.task.AbstractTaskConfigurator;
import com.atlassian.bamboo.task.TaskDefinition;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.atlassian.bamboo.ww2.actions.build.admin.create.UIConfigSupport;
import com.atlassian.struts.TextProvider;
import com.google.common.collect.ImmutableSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UnlockKeychainConfigurator
extends AbstractTaskConfigurator {
    public static final String PASSWORD = "password";
    public static final String KEYCHAIN = "keychain";
    private static final String PASSWORD_CHANGE = "passwordChange";
    private static final String NEW_PASSWORD = "newPassword";
    static final String SET_AS_DEFAULT_KEYCHAIN = "setAsDefaultKeychain";
    private static final String CTX_UI_CONFIG_BEAN = "uiConfigBean";
    private static final Set<String> FIELDS_TO_COPY = ImmutableSet.builder().add((Object)"password").add((Object)"keychain").add((Object)"setAsDefaultKeychain").build();
    private static final String INITIAL_KEYCHAIN_NAME = "login";
    protected TextProvider textProvider;
    protected UIConfigSupport uiConfigSupport;

    public void populateContextForEdit(@NotNull Map<String, Object> context, @NotNull TaskDefinition taskDefinition) {
        super.populateContextForEdit(context, taskDefinition);
        this.populateContextForAllOperations(context);
        this.taskConfiguratorHelper.populateContextWithConfiguration(context, taskDefinition, FIELDS_TO_COPY);
        context.put("mode", "edit");
    }

    public void populateContextForCreate(@NotNull Map<String, Object> context) {
        super.populateContextForCreate(context);
        this.populateContextForAllOperations(context);
        context.put("mode", "create");
        context.put(KEYCHAIN, INITIAL_KEYCHAIN_NAME);
        context.put(SET_AS_DEFAULT_KEYCHAIN, Boolean.TRUE);
    }

    @NotNull
    public Map<String, String> generateTaskConfigMap(@NotNull ActionParametersMap params, @Nullable TaskDefinition previousTaskDefinition) {
        Map config = super.generateTaskConfigMap(params, previousTaskDefinition);
        this.taskConfiguratorHelper.populateTaskConfigMapWithActionParameters(config, params, FIELDS_TO_COPY);
        String passwordChange = params.getString(PASSWORD_CHANGE);
        if ("true".equals(passwordChange)) {
            String password = params.getString(NEW_PASSWORD);
            config.put(PASSWORD, password);
        } else if (previousTaskDefinition != null) {
            config.put(PASSWORD, previousTaskDefinition.getConfiguration().get(PASSWORD));
        } else {
            String password = params.getString(PASSWORD);
            config.put(PASSWORD, password);
        }
        return config;
    }

    public void validate(@NotNull ActionParametersMap params, @NotNull ErrorCollection errorCollection) {
        super.validate(params, errorCollection);
        if (StringUtils.isEmpty((String)params.getString(KEYCHAIN))) {
            errorCollection.addError(KEYCHAIN, this.textProvider.getText("keychain.name.error"));
        }
    }

    private void populateContextForAllOperations(@NotNull Map<String, Object> context) {
        context.put(CTX_UI_CONFIG_BEAN, this.uiConfigSupport);
    }

    public void setTextProvider(TextProvider textProvider) {
        this.textProvider = textProvider;
    }

    public void setUiConfigSupport(UIConfigSupport uiConfigSupport) {
        this.uiConfigSupport = uiConfigSupport;
    }
}

