/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.xcode.build;

import com.atlassian.bamboo.build.LogEntry;
import com.atlassian.bamboo.build.logger.LogInterceptor;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import org.apache.commons.lang.StringUtils;
import org.jetbrains.annotations.NotNull;

public final class XCodeBuildLogInterceptor
implements LogInterceptor {
    private BufferedWriter bw;

    public void intercept(@NotNull LogEntry logEntry) {
        this.processLine(logEntry.getUnstyledLog());
    }

    public void interceptError(@NotNull LogEntry logEntry) {
    }

    private void processLine(@NotNull String line) {
        if (this.bw == null) {
            return;
        }
        try {
            this.bw.write(line);
            this.bw.newLine();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void open(String path, boolean append) throws IOException {
        if (StringUtils.isNotEmpty((String)path)) {
            if (this.bw != null) {
                this.close();
            }
            this.bw = new BufferedWriter(new FileWriter(path, append));
        }
    }

    public void close() {
        try {
            if (this.bw != null) {
                this.bw.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

