/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.php.task.configuration;

import com.atlassian.bamboo.build.Job;
import com.atlassian.bamboo.collections.ActionParametersMap;
import com.atlassian.bamboo.plugins.php.task.utils.PhpUnitBuildTaskHelper;
import com.atlassian.bamboo.task.AbstractTaskConfigurator;
import com.atlassian.bamboo.task.BuildTaskRequirementSupport;
import com.atlassian.bamboo.task.TaskConfigConstants;
import com.atlassian.bamboo.task.TaskDefinition;
import com.atlassian.bamboo.task.TaskTestResultsSupport;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.atlassian.bamboo.v2.build.agent.capability.Requirement;
import com.atlassian.bamboo.ww2.actions.build.admin.create.UIConfigSupport;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.opensymphony.xwork2.TextProvider;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpUnitBuildTaskConfigurator
extends AbstractTaskConfigurator
implements BuildTaskRequirementSupport,
TaskTestResultsSupport {
    private static final Logger log = Logger.getLogger(PhpUnitBuildTaskConfigurator.class);
    private static final Map<String, Object> DEFAULTS = ImmutableMap.of((Object)"arguments", (Object)Character.valueOf('.'), (Object)"logXmlEnabled", (Object)false, (Object)"logXmlFile", (Object)StringUtils.join((Object[])new String[]{"test-reports", "phpunit.xml"}, (String)File.separator), (Object)"coverageHtmlEnabled", (Object)false, (Object)"coverageHtmlDirectory", (Object)StringUtils.join((Object[])new String[]{"test-reports", "coverage", "html"}, (String)File.separator));
    private static final List<String> FIELDS_TO_COPY = ImmutableList.of((Object)"arguments", (Object)"logXmlEnabled", (Object)"logXmlFile", (Object)"coverageHtmlEnabled", (Object)"coverageHtmlDirectory", (Object)"pickupOutdatedFiles");
    private static final String CTX_UI_CONFIG_SUPPORT = "uiConfigSupport";
    private TextProvider textProvider;
    private UIConfigSupport uiConfigSupport;

    @NotNull
    public Set<Requirement> calculateRequirements(@NotNull TaskDefinition taskDefinition, @NotNull Job job) {
        return PhpUnitBuildTaskHelper.calculateRequirements(this.taskConfiguratorHelper, taskDefinition);
    }

    @NotNull
    public Map<String, String> generateTaskConfigMap(@NotNull ActionParametersMap params, @Nullable TaskDefinition previousTaskDefinition) {
        Map config = super.generateTaskConfigMap(params, previousTaskDefinition);
        this.taskConfiguratorHelper.populateTaskConfigMapWithActionParameters(config, params, Iterables.concat((Iterable)TaskConfigConstants.DEFAULT_BUILDER_CONFIGURATION_KEYS, FIELDS_TO_COPY));
        return config;
    }

    public void populateContextForCreate(@NotNull Map<String, Object> context) {
        super.populateContextForCreate(context);
        context.put(CTX_UI_CONFIG_SUPPORT, this.uiConfigSupport);
        context.putAll(DEFAULTS);
    }

    public void populateContextForEdit(@NotNull Map<String, Object> context, @NotNull TaskDefinition taskDefinition) {
        super.populateContextForEdit(context, taskDefinition);
        context.put(CTX_UI_CONFIG_SUPPORT, this.uiConfigSupport);
        this.taskConfiguratorHelper.populateContextWithConfiguration(context, taskDefinition, Iterables.concat((Iterable)TaskConfigConstants.DEFAULT_BUILDER_CONFIGURATION_KEYS, FIELDS_TO_COPY));
    }

    public void validate(@NotNull ActionParametersMap params, @NotNull ErrorCollection errorCollection) {
        this.taskConfiguratorHelper.validateBuilderLabel(params, errorCollection);
        if (StringUtils.isEmpty((CharSequence)params.getString("arguments"))) {
            errorCollection.addError("arguments", this.textProvider.getText("task.phpunit.validate.arguments.mandatory"));
        }
        if (params.getBoolean("logXmlEnabled") && StringUtils.isEmpty((CharSequence)params.getString("logXmlFile"))) {
            errorCollection.addError("logXmlEnabled", this.textProvider.getText("task.phpunit.validate.junit.filename.empty"));
        }
    }

    public boolean taskProducesTestResults(@NotNull TaskDefinition taskDefinition) {
        return Boolean.parseBoolean((String)taskDefinition.getConfiguration().get("logXmlEnabled"));
    }

    public void setTextProvider(TextProvider textProvider) {
        this.textProvider = textProvider;
    }

    public void setUiConfigSupport(UIConfigSupport uiConfigSupport) {
        this.uiConfigSupport = uiConfigSupport;
    }
}

