/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.variable.inject;

import com.atlassian.bamboo.collections.ActionParametersMap;
import com.atlassian.bamboo.plugins.variable.inject.VariableScope;
import com.atlassian.bamboo.specs.model.task.InjectVariablesTaskProperties;
import com.atlassian.bamboo.task.AbstractTaskConfigurator;
import com.atlassian.bamboo.task.TaskDefinition;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.message.I18nResolver;
import com.google.common.collect.ImmutableList;
import java.util.Map;
import java.util.regex.Pattern;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InjectVariablesTaskConfigurator
extends AbstractTaskConfigurator {
    private static final String CFG_SCOPE_LIST = "scopes";
    private static final ImmutableList<String> VARIABLE_TYPES = ImmutableList.of((Object)VariableScope.LOCAL.name(), (Object)VariableScope.RESULT.name());
    private static final Pattern VALID_NAMESPACE_PATTERN = Pattern.compile("[a-z0-9_\\.]+", 2);
    private final I18nResolver i18nResolver;

    @Inject
    public InjectVariablesTaskConfigurator(@ComponentImport I18nResolver i18nResolver) {
        this.i18nResolver = i18nResolver;
    }

    @NotNull
    public Map<String, String> generateTaskConfigMap(@NotNull ActionParametersMap params, @Nullable TaskDefinition previousTaskDefinition) {
        Map config = super.generateTaskConfigMap(params, previousTaskDefinition);
        config.put("filePath", params.getString("filePath"));
        config.put("scope", params.getString("scope", VariableScope.LOCAL.name()));
        config.put("namespace", params.getString("namespace", InjectVariablesTaskProperties.DEFAULT_NAMESPACE));
        return config;
    }

    public void populateContextForCreate(@NotNull Map<String, Object> context) {
        super.populateContextForCreate(context);
        context.put(CFG_SCOPE_LIST, VARIABLE_TYPES);
        context.put("scope", VariableScope.LOCAL.name());
        context.put("namespace", InjectVariablesTaskProperties.DEFAULT_NAMESPACE);
    }

    public void populateContextForEdit(@NotNull Map<String, Object> context, @NotNull TaskDefinition taskDefinition) {
        super.populateContextForEdit(context, taskDefinition);
        context.put(CFG_SCOPE_LIST, VARIABLE_TYPES);
        context.put("filePath", taskDefinition.getConfiguration().get("filePath"));
        String namespace = (String)taskDefinition.getConfiguration().get("namespace");
        context.put("namespace", StringUtils.defaultIfBlank((CharSequence)namespace, (CharSequence)InjectVariablesTaskProperties.DEFAULT_NAMESPACE));
        String scope = (String)taskDefinition.getConfiguration().get("scope");
        if (StringUtils.isEmpty((CharSequence)scope)) {
            scope = VariableScope.LOCAL.name();
        }
        context.put("scope", scope);
    }

    public void validate(@NotNull ActionParametersMap params, @NotNull ErrorCollection errorCollection) {
        String namespace;
        super.validate(params, errorCollection);
        String sayValue = params.getString("filePath");
        if (StringUtils.isBlank((CharSequence)sayValue)) {
            errorCollection.addError("filePath", this.i18nResolver.getText("com.atlassian.bamboo.plugins.inject.filename.empty"));
        }
        if (StringUtils.isBlank((CharSequence)(namespace = params.getString("namespace")))) {
            errorCollection.addError("namespace", this.i18nResolver.getText("com.atlassian.bamboo.plugins.inject.namespace.empty"));
        } else if (!VALID_NAMESPACE_PATTERN.matcher(namespace).matches()) {
            errorCollection.addError("namespace", this.i18nResolver.getText("com.atlassian.bamboo.plugins.inject.namespace.alpha"));
        }
    }
}

