/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.nodejs.tasks.nodeunit;

import com.atlassian.bamboo.collections.ActionParametersMap;
import com.atlassian.bamboo.plugins.nodejs.tasks.AbstractNodeRequiringTaskConfigurator;
import com.atlassian.bamboo.specs.builders.task.NodeunitTask;
import com.atlassian.bamboo.task.TaskDefinition;
import com.atlassian.bamboo.task.TaskTestResultsSupport;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public class NodeunitConfigurator
extends AbstractNodeRequiringTaskConfigurator
implements TaskTestResultsSupport {
    private static final String NODEUNIT_DEFAULT_EXECUTABLE = NodeunitTask.DEFAULT_NODEUNIT_EXECUTABLE;
    public static final String NODEUNIT_RUNTIME = "nodeunitRuntime";
    public static final String TEST_FILES = "testFiles";
    public static final String TEST_RESULTS_DIRECTORY = "testResultsDir";
    public static final String PARSE_TEST_RESULTS = "parseTestResults";
    public static final String ARGUMENTS = "arguments";
    protected static final Set<String> FIELDS_TO_COPY = ImmutableSet.builder().addAll(AbstractNodeRequiringTaskConfigurator.FIELDS_TO_COPY).add((Object)"nodeunitRuntime").add((Object)"testFiles").add((Object)"testResultsDir").add((Object)"parseTestResults").add((Object)"arguments").build();
    protected static final Map<String, Object> DEFAULT_FIELD_VALUES = ImmutableMap.builder().putAll(AbstractNodeRequiringTaskConfigurator.DEFAULT_FIELD_VALUES).put((Object)"nodeunitRuntime", (Object)NODEUNIT_DEFAULT_EXECUTABLE).put((Object)"testFiles", (Object)NodeunitTask.DEFAULT_TEST_DIRECTORY).put((Object)"testResultsDir", (Object)NodeunitTask.DEFAULT_RESULTS_DIRECTORY).put((Object)"parseTestResults", (Object)NodeunitTask.DEFAULT_PARSE_TEST_RESULTS).build();

    @Override
    public void validate(@NotNull ActionParametersMap params, @NotNull ErrorCollection errorCollection) {
        super.validate(params, errorCollection);
        if (StringUtils.isEmpty((CharSequence)params.getString(NODEUNIT_RUNTIME))) {
            errorCollection.addError(NODEUNIT_RUNTIME, this.i18nResolver.getText("nodeunit.runtime.error.empty"));
        }
        if (StringUtils.isEmpty((CharSequence)params.getString(TEST_FILES))) {
            errorCollection.addError(TEST_FILES, this.i18nResolver.getText("nodeunit.testFiles.error.empty"));
        }
        if (StringUtils.isEmpty((CharSequence)params.getString(TEST_RESULTS_DIRECTORY))) {
            errorCollection.addError(TEST_RESULTS_DIRECTORY, this.i18nResolver.getText("nodeunit.testResultsDir.error.empty"));
        }
    }

    public boolean taskProducesTestResults(@NotNull TaskDefinition taskDefinition) {
        return Boolean.parseBoolean((String)taskDefinition.getConfiguration().get(PARSE_TEST_RESULTS));
    }

    @Override
    @NotNull
    public Set<String> getFieldsToCopy() {
        return FIELDS_TO_COPY;
    }

    @Override
    @NotNull
    public Map<String, Object> getDefaultFieldValues() {
        return DEFAULT_FIELD_VALUES;
    }
}

