/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.nodejs.tasks.mocha.parser;

import com.atlassian.bamboo.build.test.TestCollationService;
import com.atlassian.bamboo.build.test.TestReportCollector;
import com.atlassian.bamboo.plugins.nodejs.tasks.mocha.parser.MochaReportCollector;
import com.atlassian.bamboo.task.CommonTaskContext;
import com.atlassian.bamboo.task.TaskContext;
import com.atlassian.bamboo.task.TaskException;
import com.atlassian.bamboo.task.TaskResult;
import com.atlassian.bamboo.task.TaskResultBuilder;
import com.atlassian.bamboo.task.TaskType;
import com.atlassian.bamboo.util.BambooFileUtils;
import java.io.File;
import org.jetbrains.annotations.NotNull;

public class MochaParserTaskType
implements TaskType {
    private final TestCollationService testCollationService;

    public MochaParserTaskType(TestCollationService testCollationService) {
        this.testCollationService = testCollationService;
    }

    @NotNull
    public TaskResult execute(@NotNull TaskContext taskContext) throws TaskException {
        String testFilePattern = (String)taskContext.getConfigurationMap().get((Object)"testPattern");
        String testFilePath = MochaParserTaskType.calculateEffectiveFilePattern(taskContext, testFilePattern);
        boolean pickupOutdatedResults = Boolean.parseBoolean((String)taskContext.getConfigurationMap().getOrDefault((Object)"pickupOutdatedFiles", (Object)Boolean.FALSE.toString()));
        this.testCollationService.collateTestResults(taskContext, testFilePath, (TestReportCollector)new MochaReportCollector(), pickupOutdatedResults);
        return TaskResultBuilder.newBuilder((CommonTaskContext)taskContext).checkTestFailures().build();
    }

    public static String calculateEffectiveFilePattern(@NotNull TaskContext taskContext, @NotNull String filePattern) {
        String workingDirectoryPath = BambooFileUtils.calculateRelativePath((File)taskContext.getRootDirectory(), (File)taskContext.getWorkingDirectory());
        return workingDirectoryPath + filePattern;
    }
}

