/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.nodejs.tasks.mocha.runner;

import com.atlassian.bamboo.collections.ActionParametersMap;
import com.atlassian.bamboo.plugins.nodejs.tasks.AbstractNodeRequiringTaskConfigurator;
import com.atlassian.bamboo.task.TaskDefinition;
import com.atlassian.bamboo.task.TaskTestResultsSupport;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public class MochaRunnerConfigurator
extends AbstractNodeRequiringTaskConfigurator
implements TaskTestResultsSupport {
    private static final String MOCHA_DEFAULT_EXECUTABLE = Joiner.on((String)File.separator).join((Object)"node_modules", (Object)"mocha", new Object[]{"bin", "mocha"});
    public static final String MOCHA_RUNTIME = "mochaRuntime";
    public static final String TEST_FILES = "testFiles";
    public static final String PARSE_TEST_RESULTS = "parseTestResults";
    public static final String ARGUMENTS = "arguments";
    protected static final Set<String> FIELDS_TO_COPY = ImmutableSet.builder().addAll(AbstractNodeRequiringTaskConfigurator.FIELDS_TO_COPY).add((Object)"mochaRuntime").add((Object)"testFiles").add((Object)"parseTestResults").add((Object)"arguments").build();
    protected static final Map<String, Object> DEFAULT_FIELD_VALUES = ImmutableMap.builder().putAll(AbstractNodeRequiringTaskConfigurator.DEFAULT_FIELD_VALUES).put((Object)"mochaRuntime", (Object)MOCHA_DEFAULT_EXECUTABLE).put((Object)"testFiles", (Object)"test/").put((Object)"parseTestResults", (Object)true).build();

    @Override
    public void validate(@NotNull ActionParametersMap params, @NotNull ErrorCollection errorCollection) {
        super.validate(params, errorCollection);
        if (StringUtils.isBlank((CharSequence)params.getString(MOCHA_RUNTIME))) {
            errorCollection.addError(MOCHA_RUNTIME, this.i18nResolver.getText("mocha.runner.runtime.error.empty"));
        }
        if (StringUtils.isEmpty((CharSequence)params.getString(TEST_FILES))) {
            errorCollection.addError(TEST_FILES, this.i18nResolver.getText("mocha.runner.testFiles.error.empty"));
        }
    }

    public boolean taskProducesTestResults(@NotNull TaskDefinition taskDefinition) {
        return Boolean.parseBoolean((String)taskDefinition.getConfiguration().get(PARSE_TEST_RESULTS));
    }

    @Override
    @NotNull
    public Set<String> getFieldsToCopy() {
        return FIELDS_TO_COPY;
    }

    @Override
    @NotNull
    public Map<String, Object> getDefaultFieldValues() {
        return DEFAULT_FIELD_VALUES;
    }
}

