/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.nodejs.tasks.grunt;

import com.atlassian.bamboo.collections.ActionParametersMap;
import com.atlassian.bamboo.plugins.nodejs.tasks.AbstractNodeRequiringTaskConfigurator;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public class GruntConfigurator
extends AbstractNodeRequiringTaskConfigurator {
    public static final String GRUNT_DEFAULT_EXECUTABLE = Joiner.on((String)File.separator).join((Object)"node_modules", (Object)"grunt-cli", new Object[]{"bin", "grunt"});
    public static final String GRUNT_RUNTIME = "gruntRuntime";
    public static final String TASK = "task";
    public static final String CONFIG_FILE = "configFile";
    protected static final Set<String> FIELDS_TO_COPY = ImmutableSet.builder().addAll(AbstractNodeRequiringTaskConfigurator.FIELDS_TO_COPY).add((Object)"gruntRuntime").add((Object)"task").add((Object)"configFile").build();
    protected static final Map<String, Object> DEFAULT_FIELD_VALUES = ImmutableMap.builder().putAll(AbstractNodeRequiringTaskConfigurator.DEFAULT_FIELD_VALUES).put((Object)"gruntRuntime", (Object)GRUNT_DEFAULT_EXECUTABLE).build();

    @Override
    public void validate(@NotNull ActionParametersMap params, @NotNull ErrorCollection errorCollection) {
        super.validate(params, errorCollection);
        if (StringUtils.isBlank((CharSequence)params.getString(GRUNT_RUNTIME))) {
            errorCollection.addError(GRUNT_RUNTIME, this.i18nResolver.getText("grunt.runtime.error.empty"));
        }
    }

    @Override
    @NotNull
    public Set<String> getFieldsToCopy() {
        return FIELDS_TO_COPY;
    }

    @Override
    @NotNull
    public Map<String, Object> getDefaultFieldValues() {
        return DEFAULT_FIELD_VALUES;
    }
}

