/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.docker.upgrade;

import com.atlassian.bamboo.deployments.environments.Environment;
import com.atlassian.bamboo.deployments.environments.service.EnvironmentService;
import com.atlassian.bamboo.deployments.environments.service.EnvironmentTaskService;
import com.atlassian.bamboo.plan.PlanPredicates;
import com.atlassian.bamboo.plan.cache.CachedPlanManager;
import com.atlassian.bamboo.plan.cache.ImmutableJob;
import com.atlassian.bamboo.plugin.BambooPluginUtils;
import com.atlassian.bamboo.task.TaskConfigurationService;
import com.atlassian.bamboo.task.TaskDefinition;
import com.atlassian.sal.api.message.Message;
import com.atlassian.sal.api.upgrade.PluginUpgradeTask;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurableVolumesAndWorkDirUpgradeTask
implements PluginUpgradeTask {
    private static final Logger log = LoggerFactory.getLogger(ConfigurableVolumesAndWorkDirUpgradeTask.class);
    private final CachedPlanManager planManager;
    private final TaskConfigurationService taskConfigurationService;
    private final EnvironmentService environmentService;
    private final EnvironmentTaskService environmentTaskService;

    public ConfigurableVolumesAndWorkDirUpgradeTask(@NotNull CachedPlanManager planManager, @NotNull TaskConfigurationService taskConfigurationService, @NotNull EnvironmentService environmentService, @NotNull EnvironmentTaskService environmentTaskService) {
        this.planManager = planManager;
        this.taskConfigurationService = taskConfigurationService;
        this.environmentService = environmentService;
        this.environmentTaskService = environmentTaskService;
    }

    public int getBuildNumber() {
        return 1;
    }

    public String getShortDescription() {
        return "Set default volume and work dir configuration in existing docker tasks.";
    }

    public Collection<Message> doUpgrade() throws Exception {
        log.info("Starting upgrade task to set default volume and work dir configuration in existing docker tasks.");
        this.upgradeJobs();
        this.upgradeEnvironments();
        log.info("Finished upgrade task to set default volume and work dir configuration in existing docker tasks.");
        return Collections.emptyList();
    }

    private void upgradeJobs() {
        List jobs = this.planManager.getPlans(ImmutableJob.class, Predicates.not((Predicate)PlanPredicates.planHasMaster()));
        int numberOfTasksUpgradedInJobs = 0;
        for (ImmutableJob job : jobs) {
            for (TaskDefinition taskDefinition : BambooPluginUtils.filterTasks((ImmutableJob)job, (String)"com.atlassian.bamboo.plugins.bamboo-docker-plugin:task.docker.cli")) {
                this.upgradeTaskDefinition(taskDefinition);
                this.taskConfigurationService.editTask(job.getPlanKey(), taskDefinition.getId(), taskDefinition.getUserDescription(), taskDefinition.isEnabled(), taskDefinition.getConfiguration(), taskDefinition.getRootDirectorySelector());
                ++numberOfTasksUpgradedInJobs;
            }
        }
        log.info(String.format("Upgraded %d docker tasks in %d jobs.", numberOfTasksUpgradedInJobs, jobs.size()));
    }

    private void upgradeEnvironments() {
        Iterable environments = this.environmentService.getAllEnvironmentsNoUserContext();
        int numberOfTasksUpgradedInEnvironments = 0;
        for (Environment environment : environments) {
            for (TaskDefinition taskDefinition : BambooPluginUtils.filterTasks((Iterable)environment.getTaskDefinitions(), (String)"com.atlassian.bamboo.plugins.bamboo-docker-plugin:task.docker.cli")) {
                this.upgradeTaskDefinition(taskDefinition);
                this.environmentTaskService.editTask(environment.getId(), taskDefinition.getId(), taskDefinition.getUserDescription(), taskDefinition.isEnabled(), taskDefinition.getConfiguration());
                ++numberOfTasksUpgradedInEnvironments;
            }
        }
        log.info(String.format("Upgraded %d docker tasks in %d environments.", numberOfTasksUpgradedInEnvironments, Iterables.size((Iterable)environments)));
    }

    private void upgradeTaskDefinition(TaskDefinition taskDefinition) {
        Map taskConfig = taskDefinition.getConfiguration();
        taskConfig.put("workDir", "/data");
        taskConfig.put("hostDirectory_0", "${bamboo.working.directory}");
        taskConfig.put("containerDataVolume_0", "/data");
    }

    public String getPluginKey() {
        return "com.atlassian.bamboo.plugins.bamboo-docker-plugin";
    }
}

