/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.docker.process;

import com.atlassian.bamboo.plugins.docker.process.DockerProcessService;
import com.atlassian.bamboo.plugins.docker.process.ProcessCommand;
import com.atlassian.utils.process.ExternalProcess;
import com.atlassian.utils.process.ExternalProcessBuilder;
import com.atlassian.utils.process.OutputHandler;
import com.atlassian.utils.process.ProcessException;
import com.atlassian.utils.process.StringOutputHandler;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.util.Collections;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class DefaultDockerProcessService
implements DockerProcessService {
    private final ImmutableMap<String, String> environmentVariables;
    private final File workingDir;

    private DefaultDockerProcessService(@NotNull Builder builder) {
        this.environmentVariables = ImmutableMap.copyOf((Map)builder.environmentVariables);
        this.workingDir = builder.workingDir;
    }

    @Override
    @NotNull
    public String execute(@NotNull ProcessCommand command) throws ProcessException {
        int exitCode;
        StringOutputHandler output = new StringOutputHandler();
        StringOutputHandler error = new StringOutputHandler();
        ExternalProcess externalProcess = new ExternalProcessBuilder().command(command.getCommandList(), this.workingDir).env(this.environmentVariables).handlers((OutputHandler)output, (OutputHandler)error).build();
        try {
            externalProcess.execute();
            exitCode = externalProcess.getHandler().getExitCode();
        }
        catch (Throwable e) {
            throw new ProcessException("Could not execute '" + command.getSafeCommandString() + "': " + error.getOutput(), e);
        }
        finally {
            externalProcess.cancel();
        }
        if (exitCode != 0) {
            throw new ProcessException("Error executing '" + command.getSafeCommandString() + "', exit code: " + exitCode, exitCode);
        }
        return output.getOutput().trim();
    }

    @Override
    @NotNull
    public String executeSilently(@NotNull ProcessCommand command) throws ProcessException {
        return this.execute(command);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private Map<String, String> environmentVariables = Collections.emptyMap();
        private File workingDir;

        private Builder() {
        }

        public Builder environmentVariables(@NotNull Map<String, String> environmentVariables) {
            this.environmentVariables = environmentVariables;
            return this;
        }

        public Builder workingDir(@NotNull File workingDir) {
            this.workingDir = workingDir;
            return this;
        }

        @NotNull
        public DefaultDockerProcessService build() {
            return new DefaultDockerProcessService(this);
        }
    }
}

