package com.atlassian.bamboo.plugins.docker.client;

import org.jetbrains.annotations.NotNull;

import javax.annotation.concurrent.Immutable;

@Immutable
public class BuildConfig
{
    private final boolean nocache;

    private BuildConfig(@NotNull final Builder builder)
    {
        this.nocache = builder.nocache;
    }

    public boolean isNoCache()
    {
        return nocache;
    }

    @NotNull
    public static Builder builder()
    {
        return new Builder();
    }

    public static class Builder
    {
        private boolean nocache = false;

        private Builder()
        {
        }

        @NotNull
        public Builder nocache(final boolean nocache)
        {
            this.nocache = nocache;
            return this;
        }

        @NotNull
        public BuildConfig build()
        {
            return new BuildConfig(this);
        }
    }
}