/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.docker.validation;

import com.atlassian.bamboo.collections.ActionParametersMap;
import com.atlassian.bamboo.plugins.docker.RepositoryKey;
import com.atlassian.bamboo.plugins.docker.RepositoryKeys;
import com.atlassian.bamboo.plugins.docker.validation.ConfigValidator;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.atlassian.sal.api.message.I18nResolver;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public class PullConfigValidator
implements ConfigValidator {
    private I18nResolver i18nResolver;

    public PullConfigValidator(I18nResolver i18nResolver) {
        this.i18nResolver = i18nResolver;
    }

    @Override
    public void validate(@NotNull ActionParametersMap params, @NotNull ErrorCollection errorCollection) {
        String credentialsSource;
        RepositoryKey repositoryKey = RepositoryKeys.parseKey(params.getString("pullRepository"));
        if ("hub".equals(params.getString("pullRegistryOption"))) {
            if (repositoryKey.getRegistry() != null) {
                errorCollection.addError("pullRepository", this.i18nResolver.getText("docker.pull.repository.registry.error.notEmpty"));
            }
        } else if ("custom".equals(params.getString("pullRegistryOption")) && repositoryKey.getRegistry() == null) {
            errorCollection.addError("pullRepository", this.i18nResolver.getText("docker.pull.repository.registry.error.empty"));
        }
        if (StringUtils.isBlank((CharSequence)repositoryKey.getRepository())) {
            errorCollection.addError("pullRepository", this.i18nResolver.getText("docker.repository.error.empty"));
        }
        if ("USER".equals(credentialsSource = params.getString("pullCredentialsSource", ""))) {
            if (StringUtils.isBlank((CharSequence)params.getString("pullUsername"))) {
                errorCollection.addError("pullUsername", this.i18nResolver.getText("docker.username.error.empty"));
            }
            if (params.getBoolean("pullChangePassword") && StringUtils.isBlank((CharSequence)params.getString("pullPassword"))) {
                errorCollection.addError("pullPassword", this.i18nResolver.getText("docker.password.error.empty"));
            }
        } else if ("SHARED_CREDENTIALS".equals(credentialsSource) && params.getLong("pullSharedCredentialsId", -1L) == -1L) {
            errorCollection.addError("pullSharedCredentialsId", this.i18nResolver.getText("docker.shared_credentials.error.required"));
        }
    }
}

