/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.docker.config;

import com.atlassian.bamboo.configuration.ConfigurationMap;
import com.atlassian.bamboo.task.CommonTaskContext;
import java.io.File;
import org.jetbrains.annotations.NotNull;

public class BuildConfiguration {
    private final String dockerfileOption;
    private final String dockerfile;
    private final String repository;
    private final boolean nocache;
    private final boolean save;
    private final String filename;
    private final String additionalArguments;
    private final String environmentVariables;
    private final File workingDirectory;

    @NotNull
    public static BuildConfiguration fromContext(@NotNull CommonTaskContext taskContext) {
        return new BuildConfiguration(taskContext);
    }

    private BuildConfiguration(@NotNull CommonTaskContext taskContext) {
        ConfigurationMap configurationMap = taskContext.getConfigurationMap();
        this.dockerfileOption = (String)configurationMap.get((Object)"dockerfileOption");
        this.dockerfile = (String)configurationMap.get((Object)"dockerfile");
        this.repository = (String)configurationMap.get((Object)"repository");
        this.additionalArguments = (String)configurationMap.getOrDefault((Object)"buildOptions", (Object)"");
        this.nocache = configurationMap.getAsBoolean("nocache");
        this.save = configurationMap.getAsBoolean("save");
        this.filename = (String)configurationMap.get((Object)"filename");
        this.environmentVariables = (String)configurationMap.get((Object)"environmentVariables");
        this.workingDirectory = taskContext.getWorkingDirectory();
    }

    public boolean isDockerfileInline() {
        return "inline".equals(this.dockerfileOption);
    }

    public String getDockerfile() {
        return this.dockerfile;
    }

    public String getRepository() {
        return this.repository;
    }

    public boolean isNocache() {
        return this.nocache;
    }

    public boolean isSave() {
        return this.save;
    }

    public String getFilename() {
        return this.filename;
    }

    @NotNull
    public String getAdditionalArguments() {
        return this.additionalArguments;
    }

    public String getEnvironmentVariables() {
        return this.environmentVariables;
    }

    public File getWorkingDirectory() {
        return this.workingDirectory;
    }
}

