/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.docker.client;

import com.atlassian.bamboo.docker.DockerContainerService;
import com.atlassian.bamboo.docker.DockerException;
import com.atlassian.bamboo.docker.RunConfig;
import com.atlassian.bamboo.plugins.docker.client.AuthConfig;
import com.atlassian.bamboo.plugins.docker.client.BuildConfig;
import com.atlassian.bamboo.plugins.docker.client.Docker;
import com.atlassian.bamboo.plugins.docker.process.DockerProcessService;
import com.atlassian.bamboo.plugins.docker.process.ProcessCommand;
import com.atlassian.bamboo.process.CommandlineStringUtils;
import com.atlassian.bamboo.process.ProcessContext;
import com.atlassian.utils.process.ProcessException;
import com.google.common.base.Joiner;
import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DockerCmd
implements Docker {
    private static final Logger log = Logger.getLogger(DockerCmd.class);
    private static final File USER_HOME = new File(System.getProperty("user.home"));
    private static final File DOCKERCFG = new File(USER_HOME, ".dockercfg");
    private static final File DOCKERCFG_BACKUP = new File(USER_HOME, ".dockercfg.bamboo");
    private final String dockerPath;
    private final DockerProcessService processService;
    private final DockerContainerService dockerContainerService;
    private final ProcessContext processContext;

    public DockerCmd(@NotNull ProcessContext processContext, @NotNull String dockerPath, @NotNull DockerProcessService processService, @NotNull DockerContainerService dockerContainerService) {
        this.dockerPath = dockerPath;
        this.processService = processService;
        this.dockerContainerService = dockerContainerService;
        this.processContext = processContext;
    }

    @Override
    public void run(@NotNull String imageName, @NotNull RunConfig runConfig) throws DockerException {
        this.dockerContainerService.run(this.processContext, Paths.get(this.dockerPath, new String[0]), imageName, runConfig, this.processService.getWorkingDirectory(), this.processService.getEnvironmentVariables());
    }

    @Override
    public boolean isRunning(@NotNull String containerName) throws DockerException {
        return this.dockerContainerService.isRunning(this.processContext, Paths.get(this.dockerPath, new String[0]), containerName, this.processService.getWorkingDirectory(), this.processService.getEnvironmentVariables());
    }

    @Override
    @Nullable
    public Integer getHostPort(@NotNull String containerName, @NotNull Integer containerPort) throws DockerException {
        return this.dockerContainerService.getHostPort(this.processContext, Paths.get(this.dockerPath, new String[0]), containerName, containerPort, this.processService.getWorkingDirectory(), this.processService.getEnvironmentVariables());
    }

    @Override
    public void remove(@NotNull String containerName) throws DockerException {
        this.dockerContainerService.remove(this.processContext, Paths.get(this.dockerPath, new String[0]), containerName, this.processService.getWorkingDirectory(), this.processService.getEnvironmentVariables());
    }

    @Override
    public void build(@NotNull File dockerFolder, @NotNull String repository, @NotNull BuildConfig buildConfig) throws DockerException {
        ProcessCommand.Builder buildCommand = ProcessCommand.builder().add(this.dockerPath, "build");
        if (buildConfig.isNoCache()) {
            buildCommand.add("--no-cache=true");
        }
        if (!buildConfig.getAdditionalArguments().contains("--force-rm")) {
            buildCommand.add("--force-rm=true");
        }
        if (StringUtils.isNotBlank((CharSequence)buildConfig.getAdditionalArguments())) {
            buildCommand.addAll(CommandlineStringUtils.tokeniseCommandline((String)buildConfig.getAdditionalArguments()));
        }
        if (!buildConfig.getAdditionalArguments().contains("--tag ") && !buildConfig.getAdditionalArguments().contains("--tag=")) {
            buildCommand.add("--tag=" + repository);
        }
        buildCommand.add(dockerFolder.getAbsolutePath());
        try {
            this.processService.execute(buildCommand.build());
        }
        catch (ProcessException e) {
            throw new DockerException("Error running Docker build command", (Throwable)e);
        }
    }

    @Override
    public void save(@NotNull String filename, @NotNull String repository) throws DockerException {
        ProcessCommand saveCommand = ProcessCommand.builder().add(this.dockerPath, "save", "--output=" + filename + "", repository).build();
        try {
            this.processService.execute(saveCommand);
        }
        catch (ProcessException e) {
            throw new DockerException("Error running Docker save command", (Throwable)e);
        }
    }

    @Override
    public void tag(@NotNull String image, @NotNull String repository, @NotNull String tag) throws DockerException {
        ProcessCommand tagCommand = ProcessCommand.builder().add(this.dockerPath, "tag", image, Joiner.on((char)':').join((Object)repository, (Object)tag, new Object[0])).build();
        try {
            this.processService.execute(tagCommand);
        }
        catch (ProcessException e) {
            throw new DockerException("Error running Docker tag command", (Throwable)e);
        }
    }

    @Override
    public void push(@NotNull String repository, @NotNull AuthConfig authConfig) throws DockerException {
        Command pushCommand = () -> this.processService.execute(ProcessCommand.builder().add(this.dockerPath, "push", repository).build());
        Command command = authConfig.isAuthorisationProvided() ? new AuthorisedCommand(authConfig, pushCommand) : pushCommand;
        try {
            command.execute();
        }
        catch (ProcessException e) {
            StringBuilder message = new StringBuilder();
            message.append("Error running Docker push command. See messages above for details.");
            if (!authConfig.isAuthorisationProvided()) {
                message.append(" If no reason is specified it may be because you have not provided").append(" login details to a registry that requires authorisation.");
            }
            throw new DockerException(message.toString(), (Throwable)e);
        }
    }

    @Override
    public void pull(@NotNull String repository, @NotNull AuthConfig authConfig) throws DockerException {
        Command pullCommand = () -> this.processService.execute(ProcessCommand.builder().add(this.dockerPath, "pull", repository).build());
        Command command = authConfig.isAuthorisationProvided() ? new AuthorisedCommand(authConfig, pullCommand) : pullCommand;
        try {
            command.execute();
        }
        catch (ProcessException e) {
            StringBuilder message = new StringBuilder();
            message.append("Error running Docker pull command. See messages above for details.");
            if (!authConfig.isAuthorisationProvided()) {
                message.append(" If no reason is specified it may be because you have not provided").append(" login details to a registry that requires authorisation.");
            }
            throw new DockerException(message.toString(), (Throwable)e);
        }
    }

    private class AuthorisedCommand
    implements Command {
        private final AuthConfig authConfig;
        private final Command command;

        private AuthorisedCommand(@NotNull AuthConfig authConfig, Command command) {
            this.authConfig = authConfig;
            this.command = command;
        }

        @Override
        public void execute() throws ProcessException {
            try {
                this.backupDockercfg();
                this.login();
                this.command.execute();
            }
            finally {
                this.logout();
                this.restoreDockercfg();
            }
        }

        private void backupDockercfg() {
            if (DOCKERCFG.exists()) {
                try {
                    FileUtils.copyFile((File)DOCKERCFG, (File)DOCKERCFG_BACKUP, (boolean)true);
                }
                catch (IOException e) {
                    log.warn((Object)"Unable to backup '.dockercfg' file. After the build, make sure the agent's '~/.dockercfg' file is still valid. ", (Throwable)e);
                }
            }
        }

        private void login() throws ProcessException {
            ProcessCommand.Builder loginCommand = ProcessCommand.builder().add(DockerCmd.this.dockerPath, "login", "-u", (String)this.authConfig.getUsername().get(), "--password-stdin").input((String)this.authConfig.getPassword().get());
            if (!this.authConfig.getEmail().isEmpty()) {
                loginCommand.add("-e", (String)this.authConfig.getEmail().get());
            }
            if (!this.authConfig.getRegistryAddress().isEmpty()) {
                loginCommand.add((String)this.authConfig.getRegistryAddress().get());
            }
            DockerCmd.this.processService.executeSilently(loginCommand.build());
        }

        private void logout() throws ProcessException {
            ProcessCommand.Builder logoutCommand = ProcessCommand.builder().add(DockerCmd.this.dockerPath, "logout");
            if (!this.authConfig.getRegistryAddress().isEmpty()) {
                logoutCommand.add((String)this.authConfig.getRegistryAddress().get());
            }
            DockerCmd.this.processService.execute(logoutCommand.build());
        }

        private void restoreDockercfg() {
            if (DOCKERCFG_BACKUP.exists()) {
                try {
                    DOCKERCFG.delete();
                    FileUtils.moveFile((File)DOCKERCFG_BACKUP, (File)DOCKERCFG);
                }
                catch (IOException e) {
                    log.warn((Object)"Unable to restore '.dockercfg' file. After the build, make sure the agent's '~/.dockercfg' file is still valid.", (Throwable)e);
                }
            }
        }
    }

    private static interface Command {
        public void execute() throws ProcessException;
    }
}

