/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.docker.client;

import javax.annotation.concurrent.Immutable;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

@Immutable
public class BuildConfig {
    private final boolean nocache;
    private final String additionalArguments;

    private BuildConfig(@NotNull Builder builder) {
        this.nocache = builder.nocache;
        this.additionalArguments = builder.additionalArguments;
    }

    public boolean isNoCache() {
        return this.nocache;
    }

    @NotNull
    public String getAdditionalArguments() {
        return this.additionalArguments;
    }

    @NotNull
    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private boolean nocache = false;
        private String additionalArguments = "";

        private Builder() {
        }

        @NotNull
        public Builder nocache(boolean nocache) {
            this.nocache = nocache;
            return this;
        }

        @NotNull
        public Builder additionalArguments(String additionalArguments) {
            this.additionalArguments = StringUtils.defaultString((String)additionalArguments);
            return this;
        }

        @NotNull
        public BuildConfig build() {
            return new BuildConfig(this);
        }
    }
}

