/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.docker;

import com.atlassian.bamboo.credentials.CredentialsAccessor;
import com.atlassian.bamboo.credentials.CredentialsData;
import com.atlassian.bamboo.task.RuntimeTaskDataProvider;
import com.atlassian.bamboo.task.TaskDefinition;
import com.atlassian.bamboo.task.runtime.RuntimeTaskDefinition;
import com.atlassian.bamboo.v2.build.CommonContext;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public class DockerRuntimeDataProvider
implements RuntimeTaskDataProvider {
    private CredentialsAccessor credentialsAccessor;

    @NotNull
    public Map<String, String> populateRuntimeTaskData(@NotNull TaskDefinition taskDefinition, @NotNull CommonContext commonContext) {
        Map configuration = taskDefinition.getConfiguration();
        HashMap<String, String> result = new HashMap<String, String>();
        this.propagateSharedCredentialsValues("pushSharedCredentialsId", "username", "password", taskDefinition, configuration, result);
        this.propagateSharedCredentialsValues("pullSharedCredentialsId", "pullUsername", "pullPassword", taskDefinition, configuration, result);
        return result;
    }

    private void propagateSharedCredentialsValues(String sharedCredentialsKey, String usernameKey, String passwordKey, @NotNull TaskDefinition taskDefinition, Map<String, String> configuration, Map<String, String> result) {
        String credentialsId = configuration.get(sharedCredentialsKey);
        if (StringUtils.isNotBlank((CharSequence)credentialsId) && !"-1".equals(credentialsId)) {
            CredentialsData credentials = this.credentialsAccessor.getCredentials(Long.parseLong(credentialsId));
            if (credentials == null) {
                throw new IllegalStateException("Can't find shared credentials with id " + credentialsId + " for task " + (StringUtils.isEmpty((CharSequence)taskDefinition.getUserDescription()) ? taskDefinition.getPluginKey() : taskDefinition.getUserDescription()));
            }
            if (credentials.getPluginKey().equals("com.atlassian.bamboo.plugin.sharedCredentials:usernamePasswordCredentials")) {
                String username = (String)credentials.getConfiguration().get("username");
                String password = (String)credentials.getConfiguration().get("password");
                result.put(usernameKey, username);
                result.put(passwordKey, password);
            }
        } else {
            result.put(usernameKey, configuration.get(usernameKey));
            result.put(passwordKey, configuration.get(passwordKey));
        }
    }

    public void processRuntimeTaskData(@NotNull TaskDefinition taskDefinition, @NotNull CommonContext commonContext) {
    }

    public void processRuntimeTaskData(@NotNull RuntimeTaskDefinition runtimeTaskDefinition, @NotNull CommonContext commonContext) {
    }

    public void setCredentialsAccessor(@ComponentImport CredentialsAccessor credentialsAccessor) {
        this.credentialsAccessor = credentialsAccessor;
    }
}

