/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.ssh;

import com.atlassian.bamboo.crypto.AtlassianRandom;
import com.atlassian.bamboo.plugins.ssh.SshClientAndServerFactory;
import java.util.concurrent.TimeUnit;
import org.apache.sshd.client.ClientBuilder;
import org.apache.sshd.client.SshClient;
import org.apache.sshd.client.config.hosts.HostConfigEntryResolver;
import org.apache.sshd.common.Factory;
import org.apache.sshd.common.NamedFactory;
import org.apache.sshd.common.random.Random;
import org.apache.sshd.common.random.SingletonRandomFactory;
import org.apache.sshd.server.ServerBuilder;
import org.apache.sshd.server.SshServer;

public class AtlassianSshClientAndServerFactory
implements SshClientAndServerFactory {
    public static final AtlassianSshClientAndServerFactory INSTANCE = new AtlassianSshClientAndServerFactory();
    private final Factory<Random> atlassianRandomFactory = new SingletonRandomFactory((NamedFactory)new AtlassianRandom.Factory());
    private final ClientBuilder sshClientBuilder = (ClientBuilder)ClientBuilder.builder().hostConfigEntryResolver(HostConfigEntryResolver.EMPTY).randomFactory(this.atlassianRandomFactory);
    private final ServerBuilder sshServerBuilder = (ServerBuilder)ServerBuilder.builder().randomFactory(this.atlassianRandomFactory);
    private final long authTimeout;
    private final long idleTimeout;

    public AtlassianSshClientAndServerFactory() {
        this(2L, TimeUnit.MINUTES, 2L, TimeUnit.MINUTES);
    }

    public AtlassianSshClientAndServerFactory(long authTimeout, TimeUnit authTimeoutUnit, long idleTimeout, TimeUnit idleTimeoutUnit) {
        this.authTimeout = authTimeoutUnit.toMillis(authTimeout);
        this.idleTimeout = idleTimeoutUnit.toMillis(idleTimeout);
    }

    @Override
    public SshClient createSshClient() {
        SshClient sshClient = (SshClient)this.sshClientBuilder.build();
        sshClient.getProperties().put("auth-timeout", Long.toString(this.authTimeout));
        sshClient.getProperties().put("idle-timeout", Long.toString(this.idleTimeout));
        return sshClient;
    }

    @Override
    public SshServer createSshServer() {
        return (SshServer)this.sshServerBuilder.build();
    }
}

