/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.ssh;

import com.atlassian.bamboo.plugins.ssh.SshProxy;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.security.KeyPair;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import org.apache.sshd.common.keyprovider.AbstractKeyPairProvider;
import org.apache.sshd.common.util.SecurityUtils;
import org.bouncycastle.openssl.PEMReader;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ClasspathKeyPairProvider
extends AbstractKeyPairProvider {
    private static final String PROXY_SERVER_KEY_PEM = "proxy-server-key.pem";
    private static final String PROXY_SERVER_KEY_LINE = "proxy-server-known-hosts.txt";
    private static final Logger log = Logger.getLogger(ClasspathKeyPairProvider.class);
    private final KeyPair[] keyPair = ClasspathKeyPairProvider.loadServerKey();

    ClasspathKeyPairProvider() {
    }

    protected KeyPair[] loadKeys() {
        return this.keyPair;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private static KeyPair[] loadServerKey() {
        if (!SecurityUtils.isBouncyCastleRegistered()) {
            log.error((Object)"Bouncycastle not registered, cannot read keys");
            return new KeyPair[0];
        }
        PEMReader reader = new PEMReader((Reader)new InputStreamReader(SshProxy.class.getResourceAsStream(PROXY_SERVER_KEY_PEM)));
        try {
            KeyPair[] keyPairArray = new KeyPair[]{(KeyPair)reader.readObject()};
            return keyPairArray;
        }
        catch (IOException e) {
            log.error((Object)"Cannot read host key", (Throwable)e);
            KeyPair[] keyPairArray = new KeyPair[]{};
            return keyPairArray;
        }
        finally {
            IOUtils.closeQuietly((Reader)reader);
        }
    }

    @Nullable
    String getKeyKnownHostsLine() {
        InputStream stream = SshProxy.class.getResourceAsStream(PROXY_SERVER_KEY_LINE);
        try {
            List lines = IOUtils.readLines((InputStream)stream);
            if (lines.isEmpty()) {
                log.warn((Object)"known_hosts entry line for key proxy-server-known-hosts.txt is empty");
                return null;
            }
            return (String)lines.get(0);
        }
        catch (IOException e) {
            log.warn((Object)"Cannot read known_hosts entry line for key", (Throwable)e);
            return null;
        }
    }
}

