<div id="github-repository-edit">
[@s.textfield labelKey='repository.github.username' name='repository.github.username' required=true /]
[#if stack.findValue('repository.github.password')?has_content]
    [@s.checkbox labelKey='repository.password.change' toggle=true name='temporary.github.password.change' /]
    [@ui.bambooSection dependsOn='temporary.github.password.change']
        [@s.password labelKey='repository.github.password' name='repository.github.temporary.password' /]
    [/@ui.bambooSection]
[#else]
    [@s.hidden name='temporary.github.password.change' value='true' /]
    [@s.password labelKey='repository.github.password' name='repository.github.temporary.password' /]
[/#if]

[@s.select labelKey='repository.github.repository' name='repository.github.repository' descriptionKey='repository.github.repository.description' fieldClass='github-repository'
    cssClass='select2-container aui-select2-container']
    [@s.param name='disabled' value=!(stack.findValue('repository.github.repository')?has_content) /]
    [@s.param name='extraUtility'][@ui.displayButton id='repository-github-load-repositories' valueKey='repository.github.loadRepositories'/][/@s.param]
    [#if stack.findValue('repository.github.repository')?has_content]
        [@s.param name='headerKey2' value=stack.findValue('repository.github.repository') /]
        [@s.param name='headerValue2' value=stack.findValue('repository.github.repository') /]
    [/#if]
[/@s.select]
</div>

<script type="text/javascript">
    if (typeof require !== 'undefined') {
        require([ 'feature/github-repository-form' ], function(RepositoryForm) {
            var rf = new RepositoryForm({
                repositoryKey: 'com.atlassian.bamboo.plugins.atlassian-bamboo-plugin-git:gh2',
                repositoryId: ${(repositoryId)!0},
                selectors: {
                    repositoryType: '#selectedRepository',
                    container: '#github-repository-edit',
                    username: 'input[name="repository.github.username"]',
                    password: 'input[name="repository.github.temporary.password"]',
                    loadRepositoriesButton: '#repository-github-load-repositories',
                    repository: 'select[name="repository.github.repository"]',
                    branch: 'select[name="repository.github.branch"]'
                }
            [#if inheritedVcsDefinition??]
                ,
                inheritedData: {
                    repository: '${inheritedVcsDefinition.vcsLocation.configuration.get("repository.github.repository")}',
                    id: '${inheritedVcsDefinition.id}'
                }
            [/#if]
            });
            rf.init();
        });
    }
</script>
