[#-- @ftlvariable name="buildConfiguration" type="com.atlassian.bamboo.ww2.actions.build.admin.create.BuildConfiguration" --]
[#-- @ftlvariable name="plan" type="com.atlassian.bamboo.plan.Plan" --]
[#-- @ftlvariable name="repository" type="com.atlassian.bamboo.plugins.git.GitRepository" --]
[#macro noCredentialsMessageBox id]
    [@ui.messageBox type='info']
        <div id="${id}">
            <p>
                [#if fn.hasRestrictedAdminPermission()]
                    [@s.text name='sharedCredentials.info.noCredentialsDefined.admin']
                        [@s.param][@s.url action='configureSharedCredentials' namespace='/admin/credentials'/][/@s.param]
                    [/@s.text]
                [#else]
                    [@s.text name='sharedCredentials.info.noCredentialsDefined.nonAdmin']
                        [@s.param][@s.url action='viewAdministrators' namespace=''/][/@s.param]
                    [/@s.text]
                [/#if]
            </p>
            <p>
                [@s.text name='sharedCredentials.info.noCredentialsDefined.moreInfo']
                    [@s.param][@help.href pageKey="shared.credentials"/][/@s.param]
                [/@s.text]
            </p>
        </div>
    [/@ui.messageBox]
[/#macro]

[@ui.bambooSection]
    [@s.textfield labelKey='repository.git.repositoryUrl' name='repository.git.repositoryUrl' longField=true required=true helpKey='git.fields' /]

    [@s.textfield labelKey='repository.git.branch' name='repository.git.branch' /]
    [#if buildConfiguration.getBoolean('repository.git.sharedCredentials.deleted')]
        [#if fn.hasRestrictedAdminPermission()]
            [@ui.messageBox type="error" titleKey="repository.git.sharedCredentials.deleted.title"]
                [@s.text name="repository.git.sharedCredentials.deleted.edit"/]
                <br/>
                [@s.text name="repository.git.sharedCredentials.deleted.update" ]
                    [@s.param][@s.url action="configureSharedCredentials" namespace="/admin" /][/@s.param]
                [/@s.text]
            [/@ui.messageBox]
        [#else]
            [@ui.messageBox type="error" titleKey="repository.git.sharedCredentials.deleted.title"]
                [@s.text name="repository.git.sharedCredentials.deleted.edit"/]
            [/@ui.messageBox]
        [/#if]
    [#else]
        [#assign defaultSelected='repository.git.authenticationType' /]
    [/#if]
    [@s.select
        labelKey='repository.git.authenticationType'
        name='repository.git.authenticationType'
        toggle=true
        list=repository.authenticationTypes
        listKey='name'
        listValue='label'
        value=defaultSelected! ]
    [/@s.select]

    [@ui.bambooSection dependsOn='repository.git.authenticationType' showOn='PASSWORD']

        [@s.radio name='repository.git.passwordCredentialsSource'
            listKey='name'
            listValue='label'
            toggle='true'
            list=repository.passwordCredentialsSources
            descriptionKey='repository.git.passwordCredentialsSource.description'
            cssClass='radio-group']
        [/@s.radio]

        [@ui.bambooSection dependsOn='repository.git.passwordCredentialsSource' showOn='CUSTOM']
            [@s.textfield labelKey='repository.git.username' name='repository.git.username' /]

            [#if buildConfiguration.getString('repository.git.password')?has_content]
                [@s.checkbox labelKey='repository.password.change' toggle=true name='temporary.git.password.change' /]
                [@ui.bambooSection dependsOn='temporary.git.password.change']
                    [@s.password labelKey='repository.git.password' name='temporary.git.password' required=false /]
                [/@ui.bambooSection]
            [#else]
                [@s.hidden name='temporary.git.password.change' value='true' /]
                [@s.password labelKey='repository.git.password' name='temporary.git.password' /]
            [/#if]
        [/@ui.bambooSection]

        [@ui.bambooSection dependsOn='repository.git.passwordCredentialsSource' showOn='SHARED_CREDENTIALS']
            [#if repository.passwordSharedCredentials.empty]
                [@noCredentialsMessageBox id='repository.git.passwordSharedCredentials.infoBox'/]
            [#else]
                [@s.select
                    labelKey='repository.git.sharedCredentials'
                    name='repository.git.passwordSharedCredentials'
                    toggle=true
                    list=repository.passwordSharedCredentials
                    listKey='name'
                    listValue='label']
                [/@s.select]
            [/#if]
        [/@ui.bambooSection]
    [/@ui.bambooSection]

    [@ui.bambooSection dependsOn='repository.git.authenticationType' showOn='SSH_KEYPAIR']

        [@s.radio name='repository.git.sshCredentialsSource'
            listKey='name'
            listValue='label'
            toggle='true'
            list=repository.sshCredentialsSources
            descriptionKey='repository.git.sshCredentialsSource.description'
            cssClass='radio-group']
        [/@s.radio]

        [@ui.bambooSection dependsOn='repository.git.sshCredentialsSource' showOn='CUSTOM']
            [#if buildConfiguration.getString('repository.git.ssh.key')?has_content]
                [@s.checkbox labelKey='repository.git.ssh.key.change' toggle=true name='temporary.git.ssh.key.change' /]
                [@ui.bambooSection dependsOn='temporary.git.ssh.key.change']
                    [@s.file labelKey='repository.git.ssh.key' name='temporary.git.ssh.keyfile' /]
                [/@ui.bambooSection]
            [#else]
                [@s.hidden name='temporary.git.ssh.key.change' value='true'/]
                [@s.file labelKey='repository.git.ssh.key' name='temporary.git.ssh.keyfile' /]
            [/#if]

            [#if buildConfiguration.getString('repository.git.ssh.passphrase')?has_content]
                [@s.checkbox labelKey='repository.passphrase.change' toggle=true name='temporary.git.ssh.passphrase.change' /]
                [@ui.bambooSection dependsOn='temporary.git.ssh.passphrase.change']
                    [@s.password labelKey='repository.git.ssh.passphrase' name='temporary.git.ssh.passphrase' /]
                [/@ui.bambooSection]
            [#else]
                [@s.hidden name='temporary.git.ssh.passphrase.change' value='true' /]
                [@s.password labelKey='repository.git.ssh.passphrase' name='temporary.git.ssh.passphrase' /]
            [/#if]
        [/@ui.bambooSection]

        [@ui.bambooSection dependsOn='repository.git.sshCredentialsSource' showOn='SHARED_CREDENTIALS']
            [#if repository.sshSharedCredentials.empty]
                [@noCredentialsMessageBox id='repository.git.sshSharedCredentials.infoBox'/]
            [#else]
                [@s.select
                    labelKey='repository.git.sharedCredentials'
                    name='repository.git.sharedCredentials'
                    toggle=true
                    list=repository.sshSharedCredentials
                    listKey='name'
                    listValue='label']
                [/@s.select]
            [/#if]
        [/@ui.bambooSection]

    [/@ui.bambooSection]

[/@ui.bambooSection]