/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.github;

import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.branch.VcsBranch;
import com.atlassian.bamboo.plan.vcsRevision.PlanVcsRevisionData;
import com.atlassian.bamboo.plugins.github.AbstractGitHubExecutor;
import com.atlassian.bamboo.repository.RepositoryException;
import com.atlassian.bamboo.v2.build.BuildRepositoryChanges;
import com.atlassian.bamboo.vcs.configuration.VcsRepositoryData;
import com.atlassian.bamboo.vcs.module.VcsRepositoryManager;
import com.atlassian.bamboo.vcs.runtime.ContextualVcsId;
import com.atlassian.bamboo.vcs.runtime.VcsChangeDetector;
import javax.inject.Inject;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitHubChangeDetector
extends AbstractGitHubExecutor
implements VcsChangeDetector {
    private static final Logger log = Logger.getLogger(GitHubChangeDetector.class);

    @Inject
    public GitHubChangeDetector(VcsRepositoryManager vcsRepositoryManager) {
        super(vcsRepositoryManager);
    }

    @NotNull
    public BuildRepositoryChanges collectChangesSinceRevision(@NotNull PlanKey planKey, @NotNull VcsRepositoryData repositoryData, @NotNull PlanVcsRevisionData lastRevisionData) throws RepositoryException {
        return this.getChangeDetector().collectChangesSinceRevision(planKey, GitHubChangeDetector.githubToGitData(repositoryData), lastRevisionData);
    }

    @NotNull
    public BuildRepositoryChanges collectChangesForRevision(@NotNull PlanKey planKey, @NotNull VcsRepositoryData repositoryData, @NotNull String customRevision) throws RepositoryException {
        return this.getChangeDetector().collectChangesForRevision(planKey, GitHubChangeDetector.githubToGitData(repositoryData), customRevision);
    }

    @Nullable
    public ContextualVcsId getVcsIdForExecutor(@NotNull VcsRepositoryData vcsRepositoryData) {
        return this.getChangeDetector().getVcsIdForExecutor(GitHubChangeDetector.githubToGitData(vcsRepositoryData));
    }

    public BuildRepositoryChanges collectChangesForInitialBuild(@NotNull PlanKey planKey, @NotNull VcsRepositoryData repositoryData, @NotNull VcsBranch otherBranch, boolean otherBranchUnreliable) throws RepositoryException {
        return this.getChangeDetector().collectChangesForInitialBuild(planKey, GitHubChangeDetector.githubToGitData(repositoryData), otherBranch, otherBranchUnreliable);
    }

    private VcsChangeDetector getChangeDetector() {
        return this.getGitModuleDescriptor().getChangeDetector();
    }
}

