/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.git.v2;

import com.atlassian.bamboo.build.fileserver.BuildDirectoryManager;
import com.atlassian.bamboo.credentials.CredentialsAccessor;
import com.atlassian.bamboo.plugins.git.GitRepositoryAccessData;
import com.atlassian.bamboo.plugins.git.v2.AbstractGitExecutor;
import com.atlassian.bamboo.security.TrustedKeyHelper;
import com.atlassian.bamboo.ssh.SshProxyService;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilityContext;
import com.atlassian.bamboo.variable.CustomVariableContext;
import com.atlassian.bamboo.vcs.configuration.VcsRepositoryData;
import com.atlassian.bamboo.vcs.runtime.VcsVariableGenerator;
import com.atlassian.sal.api.message.I18nResolver;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitVariableGenerator
extends AbstractGitExecutor
implements VcsVariableGenerator {
    private static final Logger log = Logger.getLogger(GitVariableGenerator.class);
    private static final String REPOSITORY_URL = "repositoryUrl";
    private static final String REPOSITORY_BRANCH = "branch";
    private static final String REPOSITORY_USERNAME = "username";

    @Inject
    public GitVariableGenerator(CapabilityContext capabilityContext, CredentialsAccessor credentialsAccessor, CustomVariableContext customVariableContext, BuildDirectoryManager buildDirectoryManager, I18nResolver i18nResolver, TrustedKeyHelper trustedKeyHelper, SshProxyService sshProxyService) {
        super(capabilityContext, credentialsAccessor, customVariableContext, buildDirectoryManager, i18nResolver, trustedKeyHelper, sshProxyService);
    }

    @Nullable
    public String getLegacyPrefix() {
        return "repository.git";
    }

    @NotNull
    public Map<String, String> getPlanRepositoryVariables(@NotNull VcsRepositoryData vcsRepositoryData) {
        GitRepositoryAccessData substitutedAccessData = this.getSubstitutedAccessData(vcsRepositoryData);
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put(REPOSITORY_URL, substitutedAccessData.getRepositoryUrl());
        variables.put(REPOSITORY_BRANCH, substitutedAccessData.getVcsBranch().getName());
        variables.put(REPOSITORY_USERNAME, substitutedAccessData.getUsername());
        return variables;
    }
}

