/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.git.helper;

import com.atlassian.bamboo.plugins.git.GitAuthenticationType;
import com.atlassian.bamboo.plugins.git.GitPasswordCredentialsSource;
import com.atlassian.bamboo.plugins.git.GitSshCredentialsSource;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.jetbrains.annotations.NotNull;

public class GitRepositorySharedCredentialsHelper {
    private GitRepositorySharedCredentialsHelper() {
    }

    public static boolean isUsingSharedCredentials(@NotNull HierarchicalConfiguration config) {
        String chosenAuthentication = config.getString("repository.git.authenticationType", GitAuthenticationType.NONE.name());
        String sshCredentialsSource = config.getString("repository.git.sshCredentialsSource", GitSshCredentialsSource.CUSTOM.name());
        String passwordCredentialsSource = config.getString("repository.git.passwordCredentialsSource", GitPasswordCredentialsSource.CUSTOM.name());
        return GitAuthenticationType.SSH_KEYPAIR.name().equals(chosenAuthentication) && GitSshCredentialsSource.SHARED_CREDENTIALS.name().equals(sshCredentialsSource) || GitAuthenticationType.PASSWORD.name().equals(chosenAuthentication) && GitPasswordCredentialsSource.SHARED_CREDENTIALS.name().equals(passwordCredentialsSource);
    }

    @NotNull
    public static String getSharedCredentialsIdField(@NotNull HierarchicalConfiguration config) {
        return GitAuthenticationType.SSH_KEYPAIR.name().equals(config.getString("repository.git.authenticationType", GitAuthenticationType.NONE.name())) ? "repository.git.sharedCredentials" : "repository.git.passwordSharedCredentials";
    }
}

