/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.git;

import com.atlassian.bamboo.v2.build.agent.capability.AbstractMultipleExecutableCapabilityTypeModule;
import com.atlassian.struts.TextProvider;
import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.List;
import javax.inject.Inject;

public class GitCapabilityTypeModule
extends AbstractMultipleExecutableCapabilityTypeModule {
    public static final String GIT_CAPABILITY = "system.git.executable";
    public static final String SSH_CAPABILITY = "system.git.executable.ssh";
    private static final String AGENT_CAPABILITY_TYPE_GIT_ERROR_UNDEFINED_EXECUTABLE = "agent.capability.type.git.error.undefinedExecutable";
    private static final String AGENT_CAPABILITY_TYPE_GIT_ERROR_UNDEFINED_EXECUTABLE_KIND = "agent.capability.type.git.error.undefinedExecutableKind";
    private static final String DEFAULT_SSH_CAPABILITY = "/usr/bin/ssh";

    @Inject
    public GitCapabilityTypeModule(TextProvider textProvider) {
        this.setTextProvider((com.opensymphony.xwork2.TextProvider)textProvider);
    }

    public String getExecutableKindKey() {
        return "gitExecutableKind";
    }

    public String getCapabilityUndefinedKey() {
        return AGENT_CAPABILITY_TYPE_GIT_ERROR_UNDEFINED_EXECUTABLE;
    }

    public String getCapabilityKindUndefinedKey() {
        return AGENT_CAPABILITY_TYPE_GIT_ERROR_UNDEFINED_EXECUTABLE_KIND;
    }

    public String getMandatoryCapabilityKey() {
        return GIT_CAPABILITY;
    }

    public List<String> getAdditionalCapabilityKeys() {
        return Lists.newArrayList((Object[])new String[]{SSH_CAPABILITY});
    }

    public List<String> getDefaultWindowPaths() {
        return Arrays.asList("C:\\Program Files\\Git\\bin", "C:\\Program Files\\git", "C:\\Program Files (x86)\\git", "C:\\git");
    }

    public String getExecutableFilename() {
        return "git";
    }

    public String getExecutableDescription(String key) {
        return this.getText("agent.capability.type." + key + ".description", new String[]{DEFAULT_SSH_CAPABILITY});
    }
}

