/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.git;

import com.atlassian.bamboo.build.fileserver.BuildDirectoryManager;
import com.atlassian.bamboo.buildqueue.manager.AgentManager;
import com.atlassian.bamboo.plan.cache.CachedPlanManager;
import com.atlassian.bamboo.plan.cache.ImmutableChain;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.plugins.git.GitCacheDirectory;
import com.atlassian.bamboo.plugins.git.GitCacheDirectoryUtils;
import com.atlassian.bamboo.plugins.git.GitRepository;
import com.atlassian.bamboo.plugins.git.GitRepositoryAccessData;
import com.atlassian.bamboo.plugins.git.GitRepositoryFacade;
import com.atlassian.bamboo.plugins.git.messages.DeleteSpecifiedGitCacheDirectoriesOnAgentMessage;
import com.atlassian.bamboo.plugins.git.messages.DeleteUnusedGitCacheDirectoriesOnAgentMessage;
import com.atlassian.bamboo.repository.CacheDescription;
import com.atlassian.bamboo.util.BambooFileUtils;
import com.atlassian.bamboo.utils.predicates.BuildAgentPredicates;
import com.atlassian.bamboo.v2.build.agent.AgentCommandSender;
import com.atlassian.bamboo.v2.build.agent.BuildAgent;
import com.atlassian.bamboo.v2.build.agent.LocalBuildAgent;
import com.atlassian.bamboo.v2.build.agent.messages.RemoteBambooMessage;
import com.atlassian.bamboo.variable.CustomVariableContext;
import com.atlassian.plugin.spring.scanner.annotation.component.BambooComponent;
import com.atlassian.sal.api.message.I18nResolver;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Collections2;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.opensymphony.xwork.ValidationAware;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import org.apache.commons.io.filefilter.DirectoryFileFilter;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

@BambooComponent
public class GitCacheHandler {
    private static final Logger log = Logger.getLogger(GitCacheHandler.class);
    private final CachedPlanManager cachedPlanManager;
    private final BuildDirectoryManager buildDirectoryManager;
    private final GitCacheDirectoryUtils gitCacheDirectoryUtils;
    private final I18nResolver i18nResolver;
    private final AgentManager agentManager;
    private final AgentCommandSender agentCommandSender;
    private final CustomVariableContext customVariableContext;

    @Inject
    public GitCacheHandler(CachedPlanManager cachedPlanManager, BuildDirectoryManager buildDirectoryManager, GitCacheDirectoryUtils gitCacheDirectoryUtils, I18nResolver i18nResolver, AgentManager agentManager, AgentCommandSender agentCommandSender, CustomVariableContext customVariableContext) {
        this.cachedPlanManager = cachedPlanManager;
        this.buildDirectoryManager = buildDirectoryManager;
        this.gitCacheDirectoryUtils = gitCacheDirectoryUtils;
        this.i18nResolver = i18nResolver;
        this.agentManager = agentManager;
        this.agentCommandSender = agentCommandSender;
        this.customVariableContext = customVariableContext;
    }

    @NotNull
    public Collection<CacheDescription> getCacheDescriptions() {
        ArrayList<CacheDescription> cacheDescriptions = new ArrayList<CacheDescription>();
        HashMultimap plans = HashMultimap.create();
        HashMap repositories = new HashMap();
        for (ImmutablePlan immutablePlan : this.cachedPlanManager.getPlans(ImmutableChain.class)) {
            this.customVariableContext.withVariableSubstitutor(this.customVariableContext.getVariableSubstitutorFactory().newSubstitutorForPlan(immutablePlan), () -> GitCacheHandler.lambda$getCacheDescriptions$0(immutablePlan, (Multimap)plans, repositories));
        }
        for (Map.Entry entry : repositories.entrySet()) {
            File cacheDir = (File)entry.getKey();
            GitRepositoryAccessData accessData = (GitRepositoryAccessData)entry.getValue();
            cacheDescriptions.add(GitCacheHandler.createCacheDescription(cacheDir, plans.get((Object)cacheDir), accessData));
        }
        Set<File> unusedDirs = this.findUnusedCaches(plans.keySet());
        for (File unusedDir : unusedDirs) {
            String description = "Descriptions for unused caches is unsupported";
            CacheDescription.FileBased cacheDescription = new CacheDescription.FileBased(unusedDir, "Descriptions for unused caches is unsupported", Collections.emptyList());
            cacheDescriptions.add((CacheDescription)cacheDescription);
        }
        return cacheDescriptions;
    }

    @NotNull
    private static CacheDescription createCacheDescription(@NotNull File cacheDir, @NotNull Collection<ImmutablePlan> usingPlans, GitRepositoryAccessData substitutedAccessData) {
        StringBuilder sb = new StringBuilder();
        sb.append("URL: '").append(substitutedAccessData.getRepositoryUrl()).append('\'');
        if (substitutedAccessData.getUsername() != null) {
            sb.append(", Username: '").append(substitutedAccessData.getUsername()).append('\'');
        }
        ArrayList<String> features = new ArrayList<String>(2);
        if (substitutedAccessData.isUseRemoteAgentCache()) {
            features.add("remote agent caching");
        }
        if (!features.isEmpty()) {
            sb.append(" (").append(StringUtils.join(features, (String)", ")).append(")");
        }
        String description = sb.toString();
        return new CacheDescription.FileBased(cacheDir, description, usingPlans);
    }

    public void deleteCaches(@NotNull Collection<String> keys, @NotNull ValidationAware feedback) {
        if (keys.isEmpty()) {
            return;
        }
        File cacheRootDir = this.getCacheRootDir();
        for (String key : keys) {
            Preconditions.checkArgument((boolean)StringUtils.isAlphanumeric((CharSequence)key), (Object)"directory traversal blocked");
            File cacheCandidate = new File(cacheRootDir, key);
            if (cacheCandidate.exists()) {
                try {
                    BambooFileUtils.deleteDirectory((File)cacheCandidate);
                    feedback.addActionMessage(this.i18nResolver.getText("manageCaches.delete.git.success", new Serializable[]{key}));
                }
                catch (IOException e) {
                    feedback.addActionError(this.i18nResolver.getText("manageCaches.delete.git.failed", new Serializable[]{key, e.getLocalizedMessage()}));
                    log.warn((Object)("Unable to delete cache " + cacheCandidate), (Throwable)e);
                }
                continue;
            }
            feedback.addActionMessage(this.i18nResolver.getText("manageCaches.delete.git.skipped", new Serializable[]{key}));
        }
        DeleteSpecifiedGitCacheDirectoriesOnAgentMessage message = new DeleteSpecifiedGitCacheDirectoriesOnAgentMessage(keys, this.gitCacheDirectoryUtils);
        Collection<String> agentNames = this.sendMessageToRemoteAgents(message);
        if (!agentNames.isEmpty()) {
            String names = StringUtils.join(agentNames, (String)", ");
            feedback.addActionMessage(this.i18nResolver.getText("manageCaches.delete.git.scheduling.deleteSpecific", new Serializable[]{names}));
        }
    }

    public void deleteUnusedCaches(@NotNull ValidationAware feedback) {
        HashSet<File> usedCaches = new HashSet<File>();
        for (Object plan : this.cachedPlanManager.getPlans(ImmutableChain.class)) {
            this.customVariableContext.withVariableSubstitutor(this.customVariableContext.getVariableSubstitutorFactory().newSubstitutorForPlan((ImmutablePlan)plan), () -> GitCacheHandler.lambda$deleteUnusedCaches$1((ImmutablePlan)plan, usedCaches));
        }
        Set<File> unusedCacheDirs = this.findUnusedCaches(usedCaches);
        for (File unusedCacheDir : unusedCacheDirs) {
            String sha = unusedCacheDir.getName();
            try {
                BambooFileUtils.deleteDirectory((File)unusedCacheDir);
                feedback.addActionMessage(this.i18nResolver.getText("manageCaches.delete.git.unused.success", new Serializable[]{sha}));
            }
            catch (IOException e) {
                feedback.addActionError(this.i18nResolver.getText("manageCaches.delete.git.unused.failed", new Serializable[]{sha, e.getLocalizedMessage()}));
            }
        }
        Collection usedSHAs = Collections2.transform(usedCaches, (Function)new Function<File, String>(){

            public String apply(File from) {
                return from.getName();
            }
        });
        DeleteUnusedGitCacheDirectoriesOnAgentMessage message = new DeleteUnusedGitCacheDirectoriesOnAgentMessage(usedSHAs, this.gitCacheDirectoryUtils);
        Collection<String> agentNames = this.sendMessageToRemoteAgents(message);
        if (!agentNames.isEmpty()) {
            String names = StringUtils.join(agentNames, (String)", ");
            feedback.addActionMessage(this.i18nResolver.getText("manageCaches.delete.git.scheduling.deleteUnused", new Serializable[]{names}));
        }
    }

    @NotNull
    private Collection<String> sendMessageToRemoteAgents(final RemoteBambooMessage message) {
        final ArrayList<String> agentNames = new ArrayList<String>();
        for (final BuildAgent buildAgent : Iterables.filter((Iterable)this.agentManager.getAllAgents(), BuildAgentPredicates::isActive)) {
            buildAgent.accept(new BuildAgent.BuildAgentVisitor(){

                public void visitLocal(LocalBuildAgent localBuildAgent) {
                }

                public void visitRemote(BuildAgent remoteBuildAgent) {
                    agentNames.add(buildAgent.getName());
                    GitCacheHandler.this.agentCommandSender.send(message, Long.valueOf(buildAgent.getId()));
                }
            });
        }
        return agentNames;
    }

    @NotNull
    private Set<File> findUnusedCaches(@NotNull Set<File> usedCaches) {
        Object[] cacheDirs = this.getCacheRootDir().listFiles((FileFilter)DirectoryFileFilter.DIRECTORY);
        return ArrayUtils.isEmpty((Object[])cacheDirs) ? Collections.emptySet() : Sets.difference((Set)ImmutableSet.copyOf((Object[])cacheDirs), usedCaches);
    }

    @NotNull
    private File getCacheRootDir() {
        return GitCacheDirectory.getCacheDirectoryRoot(this.buildDirectoryManager.getBaseBuildWorkingDirectory());
    }

    private static /* synthetic */ void lambda$deleteUnusedCaches$1(ImmutablePlan plan, Set usedCaches) {
        for (GitRepository gitRepository : GitRepositoryFacade.GIT_REPOSITORIES_OF_PLAN.apply(plan)) {
            usedCaches.add(gitRepository.getCacheDirectory());
        }
    }

    private static /* synthetic */ void lambda$getCacheDescriptions$0(ImmutablePlan plan, Multimap plans, Map repositories) {
        for (GitRepository gitRepository : GitRepositoryFacade.GIT_REPOSITORIES_OF_PLAN.apply(plan)) {
            File cacheDir = gitRepository.getCacheDirectory();
            plans.put((Object)cacheDir, (Object)plan);
            if (repositories.containsKey(cacheDir)) continue;
            repositories.put(cacheDir, gitRepository.getSubstitutedAccessData());
        }
    }
}

