/*
 * Decompiled with CFR 0.152.
 */
package org.shaded.eclipse.jgit.util;

import java.util.Arrays;
import org.shaded.eclipse.jgit.lib.Constants;
import org.shaded.eclipse.jgit.util.RawParseUtils;

public abstract class QuotedString {
    public static final GitPathStyle GIT_PATH = new GitPathStyle();
    public static final BourneStyle BOURNE = new BourneStyle();
    public static final BourneUserPathStyle BOURNE_USER_PATH = new BourneUserPathStyle();

    public abstract String quote(String var1);

    public String dequote(String in) {
        byte[] b = Constants.encode(in);
        return this.dequote(b, 0, b.length);
    }

    public abstract String dequote(byte[] var1, int var2, int var3);

    public static final class GitPathStyle
    extends QuotedString {
        private static final byte[] quote;

        public String quote(String instr) {
            if (instr.length() == 0) {
                return "\"\"";
            }
            boolean reuse = true;
            byte[] in = Constants.encode(instr);
            StringBuilder r = new StringBuilder(2 + in.length);
            r.append('\"');
            for (int i = 0; i < in.length; ++i) {
                int c = in[i] & 0xFF;
                if (c < quote.length) {
                    byte style = quote[c];
                    if (style == 0) {
                        r.append((char)c);
                        continue;
                    }
                    if (style > 0) {
                        reuse = false;
                        r.append('\\');
                        r.append((char)style);
                        continue;
                    }
                }
                reuse = false;
                r.append('\\');
                r.append((char)((c >> 6 & 3) + 48));
                r.append((char)((c >> 3 & 7) + 48));
                r.append((char)((c >> 0 & 7) + 48));
            }
            if (reuse) {
                return instr;
            }
            r.append('\"');
            return r.toString();
        }

        public String dequote(byte[] in, int inPtr, int inEnd) {
            if (2 <= inEnd - inPtr && in[inPtr] == 34 && in[inEnd - 1] == 34) {
                return GitPathStyle.dq(in, inPtr + 1, inEnd - 1);
            }
            return RawParseUtils.decode(Constants.CHARSET, in, inPtr, inEnd);
        }

        private static String dq(byte[] in, int inPtr, int inEnd) {
            byte[] r = new byte[inEnd - inPtr];
            int rPtr = 0;
            block11: while (inPtr < inEnd) {
                byte b;
                if ((b = in[inPtr++]) != 92) {
                    r[rPtr++] = b;
                    continue;
                }
                if (inPtr == inEnd) {
                    r[rPtr++] = 92;
                    break;
                }
                switch (in[inPtr++]) {
                    case 97: {
                        r[rPtr++] = 7;
                        continue block11;
                    }
                    case 98: {
                        r[rPtr++] = 8;
                        continue block11;
                    }
                    case 102: {
                        r[rPtr++] = 12;
                        continue block11;
                    }
                    case 110: {
                        r[rPtr++] = 10;
                        continue block11;
                    }
                    case 114: {
                        r[rPtr++] = 13;
                        continue block11;
                    }
                    case 116: {
                        r[rPtr++] = 9;
                        continue block11;
                    }
                    case 118: {
                        r[rPtr++] = 11;
                        continue block11;
                    }
                    case 34: 
                    case 92: {
                        r[rPtr++] = in[inPtr - 1];
                        continue block11;
                    }
                    case 48: 
                    case 49: 
                    case 50: 
                    case 51: {
                        byte c;
                        int cp = in[inPtr - 1] - 48;
                        for (int n = 1; n < 3 && inPtr < inEnd && 48 <= (c = in[inPtr]) && c <= 55; ++inPtr, ++n) {
                            cp <<= 3;
                            cp |= c - 48;
                        }
                        r[rPtr++] = (byte)cp;
                        continue block11;
                    }
                }
                r[rPtr++] = 92;
                r[rPtr++] = in[inPtr - 1];
            }
            return RawParseUtils.decode(Constants.CHARSET, r, 0, rPtr);
        }

        private GitPathStyle() {
        }

        static {
            int i;
            quote = new byte[128];
            Arrays.fill(quote, (byte)-1);
            for (i = 48; i <= 57; ++i) {
                GitPathStyle.quote[i] = 0;
            }
            for (i = 97; i <= 122; ++i) {
                GitPathStyle.quote[i] = 0;
            }
            for (i = 65; i <= 90; ++i) {
                GitPathStyle.quote[i] = 0;
            }
            GitPathStyle.quote[32] = 0;
            GitPathStyle.quote[36] = 0;
            GitPathStyle.quote[37] = 0;
            GitPathStyle.quote[38] = 0;
            GitPathStyle.quote[42] = 0;
            GitPathStyle.quote[43] = 0;
            GitPathStyle.quote[44] = 0;
            GitPathStyle.quote[45] = 0;
            GitPathStyle.quote[46] = 0;
            GitPathStyle.quote[47] = 0;
            GitPathStyle.quote[58] = 0;
            GitPathStyle.quote[59] = 0;
            GitPathStyle.quote[61] = 0;
            GitPathStyle.quote[63] = 0;
            GitPathStyle.quote[64] = 0;
            GitPathStyle.quote[95] = 0;
            GitPathStyle.quote[94] = 0;
            GitPathStyle.quote[124] = 0;
            GitPathStyle.quote[126] = 0;
            GitPathStyle.quote[7] = 97;
            GitPathStyle.quote[8] = 98;
            GitPathStyle.quote[12] = 102;
            GitPathStyle.quote[10] = 110;
            GitPathStyle.quote[13] = 114;
            GitPathStyle.quote[9] = 116;
            GitPathStyle.quote[11] = 118;
            GitPathStyle.quote[92] = 92;
            GitPathStyle.quote[34] = 34;
        }
    }

    public static class BourneUserPathStyle
    extends BourneStyle {
        public String quote(String in) {
            if (in.matches("^~[A-Za-z0-9_-]+$")) {
                return in + "/";
            }
            if (in.matches("^~[A-Za-z0-9_-]*/.*$")) {
                int i = in.indexOf(47) + 1;
                if (i == in.length()) {
                    return in;
                }
                return in.substring(0, i) + super.quote(in.substring(i));
            }
            return super.quote(in);
        }
    }

    public static class BourneStyle
    extends QuotedString {
        public String quote(String in) {
            int i;
            StringBuilder r = new StringBuilder();
            r.append('\'');
            int start = 0;
            for (i = 0; i < in.length(); ++i) {
                switch (in.charAt(i)) {
                    case '!': 
                    case '\'': {
                        r.append(in, start, i);
                        r.append('\'');
                        r.append('\\');
                        r.append(in.charAt(i));
                        r.append('\'');
                        start = i + 1;
                    }
                }
            }
            r.append(in, start, i);
            r.append('\'');
            return r.toString();
        }

        public String dequote(byte[] in, int ip, int ie) {
            boolean inquote = false;
            byte[] r = new byte[ie - ip];
            int rPtr = 0;
            block4: while (ip < ie) {
                byte b = in[ip++];
                switch (b) {
                    case 39: {
                        inquote = !inquote;
                        continue block4;
                    }
                    case 92: {
                        if (inquote || ip == ie) {
                            r[rPtr++] = b;
                            continue block4;
                        }
                        r[rPtr++] = in[ip++];
                        continue block4;
                    }
                }
                r[rPtr++] = b;
            }
            return RawParseUtils.decode(Constants.CHARSET, r, 0, rPtr);
        }
    }
}

