/*
 * Decompiled with CFR 0.152.
 */
package org.shaded.eclipse.jgit.transport;

import java.io.IOException;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import org.shaded.eclipse.jgit.lib.AnyObjectId;
import org.shaded.eclipse.jgit.lib.ObjectId;
import org.shaded.eclipse.jgit.lib.Ref;
import org.shaded.eclipse.jgit.lib.RefComparator;
import org.shaded.eclipse.jgit.lib.Repository;
import org.shaded.eclipse.jgit.transport.PacketLineOut;
import org.shaded.eclipse.jgit.util.RefMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RefAdvertiser {
    private final StringBuilder tmpLine = new StringBuilder(100);
    private final char[] tmpId = new char[40];
    private final Set<String> capablities = new LinkedHashSet<String>();
    private final Set<ObjectId> sent = new HashSet<ObjectId>();
    private Repository repository;
    private boolean derefTags;
    private boolean first = true;

    public void init(Repository src) {
        this.repository = src;
    }

    public void setDerefTags(boolean deref) {
        this.derefTags = deref;
    }

    public void advertiseCapability(String name) {
        this.capablities.add(name);
    }

    public Set<ObjectId> send(Map<String, Ref> refs) throws IOException {
        for (Ref ref : this.getSortedRefs(refs)) {
            if (ref.getObjectId() == null) continue;
            this.advertiseAny(ref.getObjectId(), ref.getName());
            if (!this.derefTags) continue;
            if (!ref.isPeeled()) {
                if (this.repository == null) continue;
                ref = this.repository.peel(ref);
            }
            if (ref.getPeeledObjectId() == null) continue;
            this.advertiseAny(ref.getPeeledObjectId(), ref.getName() + "^{}");
        }
        return this.sent;
    }

    private Iterable<Ref> getSortedRefs(Map<String, Ref> all) {
        if (all instanceof RefMap || all instanceof SortedMap && ((SortedMap)all).comparator() == null) {
            return all.values();
        }
        return RefComparator.sort(all.values());
    }

    public void advertiseHave(AnyObjectId id) throws IOException {
        this.advertiseAnyOnce(id, ".have");
    }

    public boolean isEmpty() {
        return this.first;
    }

    private void advertiseAnyOnce(AnyObjectId obj, String refName) throws IOException {
        if (!this.sent.contains(obj)) {
            this.advertiseAny(obj, refName);
        }
    }

    private void advertiseAny(AnyObjectId obj, String refName) throws IOException {
        this.sent.add(obj.toObjectId());
        this.advertiseId(obj, refName);
    }

    public void advertiseId(AnyObjectId id, String refName) throws IOException {
        this.tmpLine.setLength(0);
        id.copyTo(this.tmpId, this.tmpLine);
        this.tmpLine.append(' ');
        this.tmpLine.append(refName);
        if (this.first) {
            this.first = false;
            if (!this.capablities.isEmpty()) {
                this.tmpLine.append('\u0000');
                for (String capName : this.capablities) {
                    this.tmpLine.append(' ');
                    this.tmpLine.append(capName);
                }
                this.tmpLine.append(' ');
            }
        }
        this.tmpLine.append('\n');
        this.writeOne(this.tmpLine);
    }

    protected abstract void writeOne(CharSequence var1) throws IOException;

    protected abstract void end() throws IOException;

    public static class PacketLineOutRefAdvertiser
    extends RefAdvertiser {
        private final PacketLineOut pckOut;

        public PacketLineOutRefAdvertiser(PacketLineOut out) {
            this.pckOut = out;
        }

        protected void writeOne(CharSequence line) throws IOException {
            this.pckOut.writeString(((Object)line).toString());
        }

        protected void end() throws IOException {
            this.pckOut.end();
        }
    }
}

