/*
 * Decompiled with CFR 0.152.
 */
package org.shaded.eclipse.jgit.transport;

import java.io.IOException;
import java.io.OutputStream;
import org.shaded.eclipse.jgit.lib.Constants;

public class PacketLineOut {
    private final OutputStream out;
    private final byte[] lenbuffer;
    private boolean flushOnEnd;
    private static final byte[] hexchar = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 97, 98, 99, 100, 101, 102};

    public PacketLineOut(OutputStream outputStream) {
        this.out = outputStream;
        this.lenbuffer = new byte[5];
        this.flushOnEnd = true;
    }

    public void setFlushOnEnd(boolean flushOnEnd) {
        this.flushOnEnd = flushOnEnd;
    }

    public void writeString(String s) throws IOException {
        this.writePacket(Constants.encode(s));
    }

    public void writePacket(byte[] packet) throws IOException {
        this.formatLength(packet.length + 4);
        this.out.write(this.lenbuffer, 0, 4);
        this.out.write(packet);
    }

    public void end() throws IOException {
        this.formatLength(0);
        this.out.write(this.lenbuffer, 0, 4);
        if (this.flushOnEnd) {
            this.flush();
        }
    }

    public void flush() throws IOException {
        this.out.flush();
    }

    private void formatLength(int w) {
        PacketLineOut.formatLength(this.lenbuffer, w);
    }

    static void formatLength(byte[] lenbuffer, int w) {
        int o = 3;
        while (o >= 0 && w != 0) {
            lenbuffer[o--] = hexchar[w & 0xF];
            w >>>= 4;
        }
        while (o >= 0) {
            lenbuffer[o--] = 48;
        }
    }
}

