/*
 * Decompiled with CFR 0.152.
 */
package org.shaded.eclipse.jgit.revwalk;

import java.io.IOException;
import org.shaded.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.shaded.eclipse.jgit.errors.MissingObjectException;
import org.shaded.eclipse.jgit.revwalk.AbstractRevQueue;
import org.shaded.eclipse.jgit.revwalk.Generator;
import org.shaded.eclipse.jgit.revwalk.RevCommit;

abstract class BlockRevQueue
extends AbstractRevQueue {
    protected BlockFreeList free = new BlockFreeList();

    protected BlockRevQueue() {
    }

    BlockRevQueue(Generator s) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        RevCommit c;
        this.outputType = s.outputType();
        s.shareFreeList(this);
        while ((c = s.next()) != null) {
            this.add(c);
        }
    }

    public void shareFreeList(BlockRevQueue q) {
        this.free = q.free;
    }

    static final class Block {
        static final int BLOCK_SIZE = 256;
        Block next;
        final RevCommit[] commits = new RevCommit[256];
        int headIndex;
        int tailIndex;

        Block() {
        }

        boolean isFull() {
            return this.tailIndex == 256;
        }

        boolean isEmpty() {
            return this.headIndex == this.tailIndex;
        }

        boolean canUnpop() {
            return this.headIndex > 0;
        }

        void add(RevCommit c) {
            this.commits[this.tailIndex++] = c;
        }

        void unpop(RevCommit c) {
            this.commits[--this.headIndex] = c;
        }

        RevCommit pop() {
            return this.commits[this.headIndex++];
        }

        RevCommit peek() {
            return this.commits[this.headIndex];
        }

        void clear() {
            this.next = null;
            this.headIndex = 0;
            this.tailIndex = 0;
        }

        void resetToMiddle() {
            this.tailIndex = 128;
            this.headIndex = 128;
        }

        void resetToEnd() {
            this.tailIndex = 256;
            this.headIndex = 256;
        }
    }

    static final class BlockFreeList {
        private Block next;

        BlockFreeList() {
        }

        Block newBlock() {
            Block b = this.next;
            if (b == null) {
                return new Block();
            }
            this.next = b.next;
            b.clear();
            return b;
        }

        void freeBlock(Block b) {
            b.next = this.next;
            this.next = b;
        }

        void clear() {
            this.next = null;
        }
    }
}

