/*
 * Decompiled with CFR 0.152.
 */
package org.shaded.eclipse.jgit.lib;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.shaded.eclipse.jgit.JGitText;
import org.shaded.eclipse.jgit.dircache.DirCache;
import org.shaded.eclipse.jgit.errors.AmbiguousObjectException;
import org.shaded.eclipse.jgit.errors.CorruptObjectException;
import org.shaded.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.shaded.eclipse.jgit.errors.MissingObjectException;
import org.shaded.eclipse.jgit.errors.NoWorkTreeException;
import org.shaded.eclipse.jgit.errors.RevisionSyntaxException;
import org.shaded.eclipse.jgit.events.ListenerList;
import org.shaded.eclipse.jgit.events.RepositoryEvent;
import org.shaded.eclipse.jgit.lib.AbbreviatedObjectId;
import org.shaded.eclipse.jgit.lib.AnyObjectId;
import org.shaded.eclipse.jgit.lib.BaseRepositoryBuilder;
import org.shaded.eclipse.jgit.lib.GitIndex;
import org.shaded.eclipse.jgit.lib.ObjectDatabase;
import org.shaded.eclipse.jgit.lib.ObjectId;
import org.shaded.eclipse.jgit.lib.ObjectInserter;
import org.shaded.eclipse.jgit.lib.ObjectLoader;
import org.shaded.eclipse.jgit.lib.ObjectReader;
import org.shaded.eclipse.jgit.lib.Ref;
import org.shaded.eclipse.jgit.lib.RefDatabase;
import org.shaded.eclipse.jgit.lib.RefRename;
import org.shaded.eclipse.jgit.lib.RefUpdate;
import org.shaded.eclipse.jgit.lib.RepositoryState;
import org.shaded.eclipse.jgit.lib.StoredConfig;
import org.shaded.eclipse.jgit.revwalk.RevBlob;
import org.shaded.eclipse.jgit.revwalk.RevCommit;
import org.shaded.eclipse.jgit.revwalk.RevObject;
import org.shaded.eclipse.jgit.revwalk.RevTree;
import org.shaded.eclipse.jgit.revwalk.RevWalk;
import org.shaded.eclipse.jgit.storage.file.ReflogReader;
import org.shaded.eclipse.jgit.treewalk.TreeWalk;
import org.shaded.eclipse.jgit.util.FS;
import org.shaded.eclipse.jgit.util.FileUtils;
import org.shaded.eclipse.jgit.util.IO;
import org.shaded.eclipse.jgit.util.RawParseUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Repository {
    private static final ListenerList globalListeners = new ListenerList();
    private final AtomicInteger useCnt = new AtomicInteger(1);
    private final File gitDir;
    private final FS fs;
    private GitIndex index;
    private final ListenerList myListeners = new ListenerList();
    private final File workTree;
    private final File indexFile;
    private Set<ObjectId> shallowChangesets;

    public static ListenerList getGlobalListenerList() {
        return globalListeners;
    }

    protected Repository(BaseRepositoryBuilder options) {
        this.gitDir = options.getGitDir();
        this.fs = options.getFS();
        this.workTree = options.getWorkTree();
        this.indexFile = options.getIndexFile();
    }

    public ListenerList getListenerList() {
        return this.myListeners;
    }

    public void fireEvent(RepositoryEvent<?> event) {
        event.setRepository(this);
        this.myListeners.dispatch(event);
        globalListeners.dispatch(event);
    }

    public void create() throws IOException {
        this.create(false);
    }

    public abstract void create(boolean var1) throws IOException;

    public File getDirectory() {
        return this.gitDir;
    }

    public abstract ObjectDatabase getObjectDatabase();

    public ObjectInserter newObjectInserter() {
        return this.getObjectDatabase().newInserter();
    }

    public ObjectReader newObjectReader() {
        return this.getObjectDatabase().newReader();
    }

    public abstract RefDatabase getRefDatabase();

    public abstract StoredConfig getConfig();

    public FS getFS() {
        return this.fs;
    }

    public boolean hasObject(AnyObjectId objectId) {
        try {
            return this.getObjectDatabase().has(objectId);
        }
        catch (IOException e) {
            return false;
        }
    }

    public ObjectLoader open(AnyObjectId objectId) throws MissingObjectException, IOException {
        return this.getObjectDatabase().open(objectId);
    }

    public ObjectLoader open(AnyObjectId objectId, int typeHint) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        return this.getObjectDatabase().open(objectId, typeHint);
    }

    public RefUpdate updateRef(String ref) throws IOException {
        return this.updateRef(ref, false);
    }

    public RefUpdate updateRef(String ref, boolean detach) throws IOException {
        return this.getRefDatabase().newUpdate(ref, detach);
    }

    public RefRename renameRef(String fromRef, String toRef) throws IOException {
        return this.getRefDatabase().newRename(fromRef, toRef);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectId resolve(String revstr) throws AmbiguousObjectException, IOException {
        RevWalk rw = new RevWalk(this);
        try {
            ObjectId objectId = this.resolve(rw, revstr);
            return objectId;
        }
        finally {
            rw.release();
        }
    }

    private ObjectId resolve(RevWalk rw, String revstr) throws IOException {
        char[] rev = revstr.toCharArray();
        AnyObjectId ref = null;
        block16: for (int i = 0; i < rev.length; ++i) {
            switch (rev[i]) {
                case '^': {
                    if (ref == null && (ref = this.parseSimple(rw, new String(rev, 0, i))) == null) {
                        return null;
                    }
                    if (i + 1 < rev.length) {
                        switch (rev[i + 1]) {
                            case '0': 
                            case '1': 
                            case '2': 
                            case '3': 
                            case '4': 
                            case '5': 
                            case '6': 
                            case '7': 
                            case '8': 
                            case '9': {
                                int pnum;
                                int j;
                                ref = rw.parseCommit(ref);
                                for (j = i + 1; j < rev.length && Character.isDigit(rev[j]); ++j) {
                                }
                                String parentnum = new String(rev, i + 1, j - i - 1);
                                try {
                                    pnum = Integer.parseInt(parentnum);
                                }
                                catch (NumberFormatException e) {
                                    throw new RevisionSyntaxException(JGitText.get().invalidCommitParentNumber, revstr);
                                }
                                if (pnum != 0) {
                                    RevCommit commit = (RevCommit)ref;
                                    ref = pnum > commit.getParentCount() ? null : commit.getParent(pnum - 1);
                                }
                                i = j - 1;
                                continue block16;
                            }
                            case '{': {
                                int k;
                                String item = null;
                                for (k = i + 2; k < rev.length; ++k) {
                                    if (rev[k] != '}') continue;
                                    item = new String(rev, i + 2, k - i - 2);
                                    break;
                                }
                                i = k;
                                if (item != null) {
                                    if (item.equals("tree")) {
                                        ref = rw.parseTree(ref);
                                        continue block16;
                                    }
                                    if (item.equals("commit")) {
                                        ref = rw.parseCommit(ref);
                                        continue block16;
                                    }
                                    if (item.equals("blob")) {
                                        if ((ref = rw.peel((RevObject)ref)) instanceof RevBlob) continue block16;
                                        throw new IncorrectObjectTypeException((ObjectId)ref, "blob");
                                    }
                                    if (item.equals("")) {
                                        ref = rw.peel((RevObject)ref);
                                        continue block16;
                                    }
                                    throw new RevisionSyntaxException(revstr);
                                }
                                throw new RevisionSyntaxException(revstr);
                            }
                            default: {
                                ref = rw.parseAny(ref);
                                if (ref instanceof RevCommit) {
                                    RevCommit commit = (RevCommit)ref;
                                    if (commit.getParentCount() == 0) {
                                        ref = null;
                                        continue block16;
                                    }
                                    ref = commit.getParent(0);
                                    continue block16;
                                }
                                throw new IncorrectObjectTypeException((ObjectId)ref, "commit");
                            }
                        }
                    }
                    if ((ref = rw.peel((RevObject)ref)) instanceof RevCommit) {
                        RevCommit commit = (RevCommit)ref;
                        if (commit.getParentCount() == 0) {
                            ref = null;
                            continue block16;
                        }
                        ref = commit.getParent(0);
                        continue block16;
                    }
                    throw new IncorrectObjectTypeException((ObjectId)ref, "commit");
                }
                case '~': {
                    int l;
                    if (ref == null && (ref = this.parseSimple(rw, new String(rev, 0, i))) == null) {
                        return null;
                    }
                    if (!((ref = rw.peel((RevObject)ref)) instanceof RevCommit)) {
                        throw new IncorrectObjectTypeException((ObjectId)ref, "commit");
                    }
                    for (l = i + 1; l < rev.length && Character.isDigit(rev[l]); ++l) {
                    }
                    String distnum = new String(rev, i + 1, l - i - 1);
                    try {
                    }
                    catch (NumberFormatException e) {
                        throw new RevisionSyntaxException(JGitText.get().invalidAncestryLength, revstr);
                    }
                    for (int dist = Integer.parseInt(distnum); dist > 0; --dist) {
                        RevCommit commit = (RevCommit)ref;
                        if (commit.getParentCount() == 0) {
                            ref = null;
                            break;
                        }
                        commit = commit.getParent(0);
                        rw.parseHeaders(commit);
                        ref = commit;
                    }
                    i = l - 1;
                    continue block16;
                }
                case '@': {
                    int m;
                    String time = null;
                    for (m = i + 2; m < rev.length; ++m) {
                        if (rev[m] != '}') continue;
                        time = new String(rev, i + 2, m - i - 2);
                        break;
                    }
                    if (time != null) {
                        throw new RevisionSyntaxException(JGitText.get().reflogsNotYetSupportedByRevisionParser, revstr);
                    }
                    i = m - 1;
                    continue block16;
                }
                case ':': {
                    RevTree tree;
                    if (ref == null) {
                        ObjectId id;
                        try {
                            id = i == 0 ? this.resolve(rw, "HEAD") : this.resolve(rw, new String(rev, 0, i));
                        }
                        catch (RevisionSyntaxException badSyntax) {
                            throw new RevisionSyntaxException(revstr);
                        }
                        if (id == null) {
                            return null;
                        }
                        tree = rw.parseTree(id);
                    } else {
                        tree = rw.parseTree(ref);
                    }
                    if (i == rev.length - i) {
                        return tree.copy();
                    }
                    TreeWalk tw = TreeWalk.forPath(rw.getObjectReader(), new String(rev, i + 1, rev.length - i - 1), tree);
                    return tw != null ? tw.getObjectId(0) : null;
                }
                default: {
                    if (ref == null) continue block16;
                    throw new RevisionSyntaxException(revstr);
                }
            }
        }
        return ref != null ? ref.copy() : this.resolveSimple(revstr);
    }

    private static boolean isHex(char c) {
        return '0' <= c && c <= '9' || 'a' <= c && c <= 'f' || 'A' <= c && c <= 'F';
    }

    private static boolean isAllHex(String str, int ptr) {
        while (ptr < str.length()) {
            if (Repository.isHex(str.charAt(ptr++))) continue;
            return false;
        }
        return true;
    }

    private RevObject parseSimple(RevWalk rw, String revstr) throws IOException {
        ObjectId id = this.resolveSimple(revstr);
        return id != null ? rw.parseAny(id) : null;
    }

    private ObjectId resolveSimple(String revstr) throws IOException {
        String s;
        if (ObjectId.isId(revstr)) {
            return ObjectId.fromString(revstr);
        }
        Ref r = this.getRefDatabase().getRef(revstr);
        if (r != null) {
            return r.getObjectId();
        }
        if (AbbreviatedObjectId.isId(revstr)) {
            return this.resolveAbbreviation(revstr);
        }
        int dashg = revstr.indexOf("-g");
        if (4 < revstr.length() && 0 <= dashg && Repository.isHex(revstr.charAt(dashg + 2)) && Repository.isHex(revstr.charAt(dashg + 3)) && Repository.isAllHex(revstr, dashg + 4) && AbbreviatedObjectId.isId(s = revstr.substring(dashg + 2))) {
            return this.resolveAbbreviation(s);
        }
        return null;
    }

    private ObjectId resolveAbbreviation(String revstr) throws IOException, AmbiguousObjectException {
        AbbreviatedObjectId id = AbbreviatedObjectId.fromString(revstr);
        ObjectReader reader = this.newObjectReader();
        try {
            Collection<ObjectId> matches = reader.resolve(id);
            if (matches.size() == 0) {
                ObjectId objectId = null;
                return objectId;
            }
            if (matches.size() == 1) {
                ObjectId objectId = matches.iterator().next();
                return objectId;
            }
            throw new AmbiguousObjectException(id, matches);
        }
        finally {
            reader.release();
        }
    }

    public void incrementOpen() {
        this.useCnt.incrementAndGet();
    }

    public void close() {
        if (this.useCnt.decrementAndGet() == 0) {
            this.doClose();
        }
    }

    protected void doClose() {
        this.getObjectDatabase().close();
        this.getRefDatabase().close();
    }

    public String toString() {
        String desc = this.getDirectory() != null ? this.getDirectory().getPath() : this.getClass().getSimpleName() + "-" + System.identityHashCode(this);
        return "Repository[" + desc + "]";
    }

    public String getFullBranch() throws IOException {
        Ref head = this.getRef("HEAD");
        if (head == null) {
            return null;
        }
        if (head.isSymbolic()) {
            return head.getTarget().getName();
        }
        if (head.getObjectId() != null) {
            return head.getObjectId().name();
        }
        return null;
    }

    public String getBranch() throws IOException {
        String name = this.getFullBranch();
        if (name != null) {
            return Repository.shortenRefName(name);
        }
        return name;
    }

    public Set<ObjectId> getAdditionalHaves() {
        return Collections.emptySet();
    }

    public Ref getRef(String name) throws IOException {
        return this.getRefDatabase().getRef(name);
    }

    public Map<String, Ref> getAllRefs() {
        try {
            return this.getRefDatabase().getRefs("");
        }
        catch (IOException e) {
            return new HashMap<String, Ref>();
        }
    }

    public Map<String, Ref> getTags() {
        try {
            return this.getRefDatabase().getRefs("refs/tags/");
        }
        catch (IOException e) {
            return new HashMap<String, Ref>();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<ObjectId> getShallows() {
        if (this.shallowChangesets == null) {
            this.shallowChangesets = new HashSet<ObjectId>();
            File shallowFile = this.getFS().resolve(this.getDirectory(), "shallow");
            if (shallowFile.exists() && shallowFile.isFile()) {
                try {
                    BufferedReader input = new BufferedReader(new FileReader(shallowFile));
                    try {
                        String line;
                        while ((line = input.readLine()) != null) {
                            this.shallowChangesets.add(ObjectId.fromString(line));
                        }
                    }
                    finally {
                        input.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return this.shallowChangesets;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeShallows(Set<ObjectId> unshallows) {
        if (unshallows.isEmpty()) {
            return;
        }
        this.getShallows();
        this.shallowChangesets.removeAll(unshallows);
        File shallowFile = this.getFS().resolve(this.getDirectory(), "shallow");
        try {
            FileWriter fw = new FileWriter(shallowFile);
            try {
                for (ObjectId shallow : this.shallowChangesets) {
                    fw.write(shallow.name() + "\n");
                }
            }
            finally {
                fw.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addShallows(Set<ObjectId> newShallows) {
        if (newShallows.isEmpty()) {
            return;
        }
        this.getShallows();
        File shallowFile = this.getFS().resolve(this.getDirectory(), "shallow");
        try {
            FileWriter fw = new FileWriter(shallowFile, true);
            try {
                for (ObjectId shallow : newShallows) {
                    if (this.shallowChangesets.contains(shallow)) continue;
                    fw.write(shallow.name() + "\n");
                    this.shallowChangesets.add(shallow);
                }
            }
            finally {
                fw.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public Ref peel(Ref ref) {
        try {
            return this.getRefDatabase().peel(ref);
        }
        catch (IOException e) {
            return ref;
        }
    }

    public Map<AnyObjectId, Set<Ref>> getAllRefsByPeeledObjectId() {
        Map<String, Ref> allRefs = this.getAllRefs();
        HashMap<AnyObjectId, Set<Ref>> ret = new HashMap<AnyObjectId, Set<Ref>>(allRefs.size());
        for (Ref ref : allRefs.values()) {
            Set<Ref> oset;
            ObjectId target = (ref = this.peel(ref)).getPeeledObjectId();
            if (target == null) {
                target = ref.getObjectId();
            }
            if ((oset = ret.put(target, Collections.singleton(ref))) == null) continue;
            if (oset.size() == 1) {
                oset = new HashSet<Ref>(oset);
            }
            ret.put(target, oset);
            oset.add(ref);
        }
        return ret;
    }

    public GitIndex getIndex() throws IOException, NoWorkTreeException {
        if (this.isBare()) {
            throw new NoWorkTreeException();
        }
        if (this.index == null) {
            this.index = new GitIndex(this);
            this.index.read();
        } else {
            this.index.rereadIfNecessary();
        }
        return this.index;
    }

    public File getIndexFile() throws NoWorkTreeException {
        if (this.isBare()) {
            throw new NoWorkTreeException();
        }
        return this.indexFile;
    }

    public DirCache readDirCache() throws NoWorkTreeException, CorruptObjectException, IOException {
        return DirCache.read(this.getIndexFile(), this.getFS());
    }

    public DirCache lockDirCache() throws NoWorkTreeException, CorruptObjectException, IOException {
        return DirCache.lock(this.getIndexFile(), this.getFS());
    }

    static byte[] gitInternalSlash(byte[] bytes) {
        if (File.separatorChar == '/') {
            return bytes;
        }
        for (int i = 0; i < bytes.length; ++i) {
            if (bytes[i] != File.separatorChar) continue;
            bytes[i] = 47;
        }
        return bytes;
    }

    public RepositoryState getRepositoryState() {
        if (this.isBare() || this.getDirectory() == null) {
            return RepositoryState.BARE;
        }
        if (new File(this.getWorkTree(), ".dotest").exists()) {
            return RepositoryState.REBASING;
        }
        if (new File(this.getDirectory(), ".dotest-merge").exists()) {
            return RepositoryState.REBASING_INTERACTIVE;
        }
        if (new File(this.getDirectory(), "rebase-apply/rebasing").exists()) {
            return RepositoryState.REBASING_REBASING;
        }
        if (new File(this.getDirectory(), "rebase-apply/applying").exists()) {
            return RepositoryState.APPLY;
        }
        if (new File(this.getDirectory(), "rebase-apply").exists()) {
            return RepositoryState.REBASING;
        }
        if (new File(this.getDirectory(), "rebase-merge/interactive").exists()) {
            return RepositoryState.REBASING_INTERACTIVE;
        }
        if (new File(this.getDirectory(), "rebase-merge").exists()) {
            return RepositoryState.REBASING_MERGE;
        }
        if (new File(this.getDirectory(), "MERGE_HEAD").exists()) {
            try {
                if (!this.readDirCache().hasUnmergedPaths()) {
                    return RepositoryState.MERGING_RESOLVED;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return RepositoryState.MERGING;
        }
        if (new File(this.getDirectory(), "BISECT_LOG").exists()) {
            return RepositoryState.BISECTING;
        }
        if (new File(this.getDirectory(), "CHERRY_PICK_HEAD").exists()) {
            try {
                if (!this.readDirCache().hasUnmergedPaths()) {
                    return RepositoryState.CHERRY_PICKING_RESOLVED;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return RepositoryState.CHERRY_PICKING;
        }
        return RepositoryState.SAFE;
    }

    public static boolean isValidRefName(String refName) {
        int len = refName.length();
        if (len == 0) {
            return false;
        }
        if (refName.endsWith(".lock")) {
            return false;
        }
        int components = 1;
        int p = 0;
        for (int i = 0; i < len; ++i) {
            char c = refName.charAt(i);
            if (c <= ' ') {
                return false;
            }
            switch (c) {
                case '.': {
                    switch (p) {
                        case 0: 
                        case 46: 
                        case 47: {
                            return false;
                        }
                    }
                    if (i != len - 1) break;
                    return false;
                }
                case '/': {
                    if (i == 0 || i == len - 1) {
                        return false;
                    }
                    ++components;
                    break;
                }
                case '{': {
                    if (p != 64) break;
                    return false;
                }
                case '*': 
                case ':': 
                case '?': 
                case '[': 
                case '\\': 
                case '^': 
                case '~': {
                    return false;
                }
            }
            p = c;
        }
        return components > 1;
    }

    public static String stripWorkDir(File workDir, File file) {
        String filePath = file.getPath();
        String workDirPath = workDir.getPath();
        if (filePath.length() <= workDirPath.length() || filePath.charAt(workDirPath.length()) != File.separatorChar || !filePath.startsWith(workDirPath)) {
            File absFile;
            File absWd = workDir.isAbsolute() ? workDir : workDir.getAbsoluteFile();
            File file2 = absFile = file.isAbsolute() ? file : file.getAbsoluteFile();
            if (absWd == workDir && absFile == file) {
                return "";
            }
            return Repository.stripWorkDir(absWd, absFile);
        }
        String relName = filePath.substring(workDirPath.length() + 1);
        if (File.separatorChar != '/') {
            relName = relName.replace(File.separatorChar, '/');
        }
        return relName;
    }

    public boolean isBare() {
        return this.workTree == null;
    }

    public File getWorkTree() throws NoWorkTreeException {
        if (this.isBare()) {
            throw new NoWorkTreeException();
        }
        return this.workTree;
    }

    public abstract void scanForRepoChanges() throws IOException;

    public static String shortenRefName(String refName) {
        if (refName.startsWith("refs/heads/")) {
            return refName.substring("refs/heads/".length());
        }
        if (refName.startsWith("refs/tags/")) {
            return refName.substring("refs/tags/".length());
        }
        if (refName.startsWith("refs/remotes/")) {
            return refName.substring("refs/remotes/".length());
        }
        return refName;
    }

    public abstract ReflogReader getReflogReader(String var1) throws IOException;

    public String readMergeCommitMsg() throws IOException, NoWorkTreeException {
        if (this.isBare() || this.getDirectory() == null) {
            throw new NoWorkTreeException();
        }
        File mergeMsgFile = new File(this.getDirectory(), "MERGE_MSG");
        try {
            return RawParseUtils.decode(IO.readFully(mergeMsgFile));
        }
        catch (FileNotFoundException e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeMergeCommitMsg(String msg) throws IOException {
        File mergeMsgFile = new File(this.gitDir, "MERGE_MSG");
        if (msg != null) {
            FileOutputStream fos = new FileOutputStream(mergeMsgFile);
            try {
                fos.write(msg.getBytes("UTF-8"));
            }
            finally {
                fos.close();
            }
        } else {
            FileUtils.delete(mergeMsgFile, 4);
        }
    }

    public List<ObjectId> readMergeHeads() throws IOException, NoWorkTreeException {
        if (this.isBare() || this.getDirectory() == null) {
            throw new NoWorkTreeException();
        }
        byte[] raw = this.readGitDirectoryFile("MERGE_HEAD");
        if (raw == null) {
            return null;
        }
        LinkedList<ObjectId> heads = new LinkedList<ObjectId>();
        int p = 0;
        while (p < raw.length) {
            heads.add(ObjectId.fromString(raw, p));
            p = RawParseUtils.nextLF(raw, p + 40);
        }
        return heads;
    }

    public void writeMergeHeads(List<ObjectId> heads) throws IOException {
        this.writeHeadsFile(heads, "MERGE_HEAD");
    }

    public ObjectId readCherryPickHead() throws IOException, NoWorkTreeException {
        if (this.isBare() || this.getDirectory() == null) {
            throw new NoWorkTreeException();
        }
        byte[] raw = this.readGitDirectoryFile("CHERRY_PICK_HEAD");
        if (raw == null) {
            return null;
        }
        return ObjectId.fromString(raw, 0);
    }

    public void writeCherryPickHead(ObjectId head) throws IOException {
        List<ObjectId> heads = head != null ? Collections.singletonList(head) : null;
        this.writeHeadsFile(heads, "CHERRY_PICK_HEAD");
    }

    private byte[] readGitDirectoryFile(String filename) throws IOException {
        File file = new File(this.getDirectory(), filename);
        try {
            byte[] raw = IO.readFully(file);
            return (byte[])(raw.length > 0 ? raw : null);
        }
        catch (FileNotFoundException notFound) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeHeadsFile(List<ObjectId> heads, String filename) throws FileNotFoundException, IOException {
        File headsFile = new File(this.getDirectory(), filename);
        if (heads != null) {
            BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(headsFile));
            try {
                for (ObjectId id : heads) {
                    id.copyTo(bos);
                    bos.write(10);
                }
            }
            finally {
                bos.close();
            }
        } else {
            FileUtils.delete(headsFile, 4);
        }
    }
}

