/*
 * Decompiled with CFR 0.152.
 */
package org.shaded.eclipse.jgit.dircache;

import java.io.IOException;
import org.shaded.eclipse.jgit.dircache.DirCacheBuilder;
import org.shaded.eclipse.jgit.dircache.DirCacheIterator;
import org.shaded.eclipse.jgit.dircache.DirCacheTree;
import org.shaded.eclipse.jgit.errors.CorruptObjectException;
import org.shaded.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.shaded.eclipse.jgit.lib.ObjectReader;
import org.shaded.eclipse.jgit.treewalk.AbstractTreeIterator;

public class DirCacheBuildIterator
extends DirCacheIterator {
    private final DirCacheBuilder builder;

    public DirCacheBuildIterator(DirCacheBuilder dcb) {
        super(dcb.getDirCache());
        this.builder = dcb;
    }

    DirCacheBuildIterator(DirCacheBuildIterator p, DirCacheTree dct) {
        super(p, dct);
        this.builder = p.builder;
    }

    public AbstractTreeIterator createSubtreeIterator(ObjectReader reader) throws IncorrectObjectTypeException, IOException {
        if (this.currentSubtree == null) {
            throw new IncorrectObjectTypeException(this.getEntryObjectId(), "tree");
        }
        return new DirCacheBuildIterator(this, this.currentSubtree);
    }

    public void skip() throws CorruptObjectException {
        if (this.currentSubtree != null) {
            this.builder.keep(this.ptr, this.currentSubtree.getEntrySpan());
        } else {
            this.builder.keep(this.ptr, 1);
        }
        this.next(1);
    }

    public void stopWalk() {
        int cur = this.ptr;
        int cnt = this.cache.getEntryCount();
        if (cur < cnt) {
            this.builder.keep(cur, cnt - cur);
        }
    }
}

