/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.aws.codedeploy;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.codedeploy.AmazonCodeDeploy;
import com.amazonaws.services.codedeploy.model.BundleType;
import com.amazonaws.services.codedeploy.model.CreateDeploymentRequest;
import com.amazonaws.services.codedeploy.model.CreateDeploymentResult;
import com.amazonaws.services.codedeploy.model.DeploymentInfo;
import com.amazonaws.services.codedeploy.model.DeploymentOverview;
import com.amazonaws.services.codedeploy.model.ErrorInformation;
import com.amazonaws.services.codedeploy.model.GetDeploymentRequest;
import com.amazonaws.services.codedeploy.model.RevisionLocation;
import com.amazonaws.services.codedeploy.model.RevisionLocationType;
import com.amazonaws.services.codedeploy.model.S3Location;
import com.atlassian.aws.ec2.awssdk.AwsSupportConstants;
import com.atlassian.aws.ec2.awssdk.RegionSupport;
import com.atlassian.bamboo.build.logger.BuildLogger;
import com.atlassian.bamboo.credentials.CredentialsAccessor;
import com.atlassian.bamboo.credentials.CredentialsData;
import com.atlassian.bamboo.plugins.aws.codedeploy.CodeDeployConfig;
import com.atlassian.bamboo.plugins.aws.codedeploy.DeploymentStatus;
import com.atlassian.bamboo.plugins.aws.core.AwsException;
import com.atlassian.bamboo.plugins.aws.core.codedeploy.CodeDeployClientFactory;
import com.atlassian.bamboo.plugins.aws.core.s3.S3Service;
import com.atlassian.bamboo.plugins.aws.credentials.AwsCredentials;
import com.atlassian.bamboo.task.CommonTaskContext;
import com.atlassian.bamboo.task.CommonTaskType;
import com.atlassian.bamboo.task.TaskException;
import com.atlassian.bamboo.task.TaskResult;
import com.atlassian.bamboo.task.TaskResultBuilder;
import com.atlassian.core.util.zip.ArchiveParams;
import com.atlassian.core.util.zip.ZipArchiver;
import com.atlassian.sal.api.message.I18nResolver;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FileUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CodeDeployTask
implements CommonTaskType {
    private static final String APPSPEC_FILENAME = "appspec.yml";
    private static final int PING_INTERVAL_SECONDS_CODE_DEPLOY = 15;
    private static final int RETRIES_PER_MINUTE = 4;
    private final S3Service s3Service;
    private final CodeDeployClientFactory codeDeployClientFactory;
    private final CredentialsAccessor credentialsAccessor;
    private final I18nResolver i18nResolver;

    public CodeDeployTask(@NotNull S3Service s3Service, @NotNull CodeDeployClientFactory codeDeployClientFactory, @NotNull CredentialsAccessor credentialsAccessor, @NotNull I18nResolver i18nResolver) {
        this.s3Service = s3Service;
        this.codeDeployClientFactory = codeDeployClientFactory;
        this.credentialsAccessor = credentialsAccessor;
        this.i18nResolver = i18nResolver;
    }

    @NotNull
    public TaskResult execute(@NotNull CommonTaskContext taskContext) throws TaskException {
        CodeDeployConfig codeDeployConfig = CodeDeployConfig.fromContext(taskContext);
        TaskResultBuilder taskResultBuilder = TaskResultBuilder.newBuilder((CommonTaskContext)taskContext);
        if (!this.validateAppSpecFileExists(taskContext)) {
            return taskResultBuilder.failed().build();
        }
        String s3Key = this.zipAndUploadWorkingDirToS3(taskContext, codeDeployConfig);
        if (s3Key == null || !this.executeDeployment(taskContext, codeDeployConfig, s3Key)) {
            return taskResultBuilder.failed().build();
        }
        return taskResultBuilder.build();
    }

    private boolean validateAppSpecFileExists(@NotNull CommonTaskContext taskContext) throws TaskException {
        BuildLogger buildLogger = taskContext.getBuildLogger();
        File workingDirectory = taskContext.getWorkingDirectory();
        File appSpecFile = new File(workingDirectory, APPSPEC_FILENAME);
        if (!appSpecFile.exists()) {
            buildLogger.addErrorLogEntry(this.i18nResolver.getText("aws.codedeploy.task.appSpecFile.notFound", new Serializable[]{APPSPEC_FILENAME}));
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private String zipAndUploadWorkingDirToS3(@NotNull CommonTaskContext taskContext, @NotNull CodeDeployConfig codeDeployConfig) throws TaskException {
        BuildLogger buildLogger = taskContext.getBuildLogger();
        CredentialsData credentialsData = this.credentialsAccessor.getCredentials(codeDeployConfig.getCredentialsId());
        AwsCredentials credentials = AwsCredentials.fromCredentialsData((CredentialsData)credentialsData);
        buildLogger.addBuildLogEntry(this.i18nResolver.getText("aws.codedeploy.task.zipWorkDir"));
        File bundle = this.zipWorkingDirectoryContents(taskContext, codeDeployConfig.includeHiddenFiles());
        String s3Key = bundle.getName();
        try {
            buildLogger.addBuildLogEntry(this.i18nResolver.getText("aws.codedeploy.task.uploadBundle", new Serializable[]{bundle.getName()}));
            Regions region = RegionSupport.toAwsSdkRegion((AwsSupportConstants.Region)codeDeployConfig.getRegion());
            this.s3Service.upload((AWSCredentials)credentials, region, codeDeployConfig.getS3Bucket(), s3Key, bundle);
        }
        catch (AwsException e) {
            buildLogger.addErrorLogEntry(this.i18nResolver.getText("aws.codedeploy.task.uploadBundle.error"), (Throwable)e);
            String string = null;
            return string;
        }
        finally {
            FileUtils.deleteQuietly((File)bundle);
        }
        return s3Key;
    }

    private boolean executeDeployment(@NotNull CommonTaskContext taskContext, @NotNull CodeDeployConfig codeDeployConfig, @NotNull String s3Key) throws TaskException {
        DeploymentStatus status;
        CreateDeploymentResult deploymentResult;
        BuildLogger buildLogger = taskContext.getBuildLogger();
        AmazonCodeDeploy codeDeployClient = this.getAmazonCodeDeployClient(codeDeployConfig);
        S3Location s3Location = new S3Location().withBucket(codeDeployConfig.getS3Bucket()).withKey(s3Key).withBundleType(BundleType.Zip);
        RevisionLocation revision = new RevisionLocation().withRevisionType(RevisionLocationType.S3).withS3Location(s3Location);
        CreateDeploymentRequest createDeploymentRequest = new CreateDeploymentRequest().withApplicationName(codeDeployConfig.getApplicationName()).withDeploymentGroupName(codeDeployConfig.getDeploymentGroup()).withRevision(revision);
        try {
            buildLogger.addBuildLogEntry(this.i18nResolver.getText("aws.codedeploy.task.createDeployment"));
            deploymentResult = codeDeployClient.createDeployment(createDeploymentRequest);
            buildLogger.addBuildLogEntry(this.i18nResolver.getText("aws.codedeploy.task.createDeployment.success", new Serializable[]{deploymentResult.getDeploymentId()}));
        }
        catch (AmazonServiceException e) {
            buildLogger.addErrorLogEntry(this.i18nResolver.getText("aws.codedeploy.task.createDeployment.error"), (Throwable)e);
            return false;
        }
        catch (AmazonClientException e) {
            throw new TaskException(this.i18nResolver.getText("aws.codedeploy.task.createDeployment.error"), (Throwable)e);
        }
        int count = 0;
        long maximumRetries = codeDeployConfig.getDeploymentTimeoutInMinutes() * 4L;
        do {
            status = this.retrieveDeploymentStatus(buildLogger, codeDeployClient, deploymentResult, ++count, maximumRetries);
            if (DeploymentStatus.valuesFinalisedList().contains((Object)status)) continue;
            buildLogger.addBuildLogEntry(this.i18nResolver.getText("aws.codedeploy.task.deployment.wait", new Serializable[]{Integer.valueOf(15)}));
            try {
                TimeUnit.SECONDS.sleep(15L);
            }
            catch (InterruptedException e) {
                throw new TaskException(this.i18nResolver.getText("aws.codedeploy.task.deployment.wait.interrupted"), (Throwable)e);
            }
        } while (!DeploymentStatus.valuesFinalisedList().contains((Object)status) && (long)count < maximumRetries);
        if ((long)count < maximumRetries) {
            if (!status.isSuccess()) {
                buildLogger.addErrorLogEntry(this.i18nResolver.getText("aws.codedeploy.task.deployment.error", new Serializable[]{status}));
                return false;
            }
            buildLogger.addBuildLogEntry(this.i18nResolver.getText("aws.codedeploy.task.deployment.success"));
            return true;
        }
        buildLogger.addErrorLogEntry(this.i18nResolver.getText("aws.codedeploy.task.deployment.wait.error", new Serializable[]{Long.valueOf(maximumRetries)}));
        return false;
    }

    private DeploymentStatus retrieveDeploymentStatus(@NotNull BuildLogger buildLogger, @NotNull AmazonCodeDeploy codeDeployClient, @NotNull CreateDeploymentResult deploymentResult, int count, long maximumRetries) {
        try {
            ErrorInformation errorInformation;
            DeploymentInfo deployment = codeDeployClient.getDeployment(new GetDeploymentRequest().withDeploymentId(deploymentResult.getDeploymentId())).getDeploymentInfo();
            String status = deployment.getStatus();
            buildLogger.addBuildLogEntry(this.i18nResolver.getText("aws.codedeploy.task.deployment.status", new Serializable[]{Integer.valueOf(count), Long.valueOf(maximumRetries), status}));
            DeploymentOverview deploymentOverview = deployment.getDeploymentOverview();
            if (deploymentOverview != null) {
                buildLogger.addBuildLogEntry(this.i18nResolver.getText("aws.codedeploy.task.deployment.overview", new Serializable[]{deploymentOverview.toString()}));
            }
            if ((errorInformation = deployment.getErrorInformation()) != null) {
                buildLogger.addErrorLogEntry(this.i18nResolver.getText("aws.codedeploy.task.deployment.error.message", new Serializable[]{errorInformation.getCode(), errorInformation.getMessage()}));
            }
            return DeploymentStatus.fromDisplayName(status);
        }
        catch (AmazonClientException e) {
            buildLogger.addErrorLogEntry(this.i18nResolver.getText("aws.codedeploy.task.deployment.status.error"), (Throwable)e);
            return DeploymentStatus.UNKNOWN;
        }
    }

    @NotNull
    private AmazonCodeDeploy getAmazonCodeDeployClient(@NotNull CodeDeployConfig codeDeployConfig) {
        CredentialsData credentialsData = this.credentialsAccessor.getCredentials(codeDeployConfig.getCredentialsId());
        AwsCredentials credentials = AwsCredentials.fromCredentialsData((CredentialsData)credentialsData);
        return this.codeDeployClientFactory.newAmazonCodeDeployClient((AWSCredentials)credentials, codeDeployConfig.getRegion());
    }

    @NotNull
    private File zipWorkingDirectoryContents(@NotNull CommonTaskContext taskContext, boolean includeHiddenFiles) throws TaskException {
        File zipFile = this.generateTempZipFile(taskContext);
        ZipArchiver zipArchiver = new ZipArchiver(zipFile);
        ArchiveParams parameters = ArchiveParams.builder().withIncludeHiddenFiles(includeHiddenFiles).build();
        try {
            zipArchiver.addFolder(taskContext.getWorkingDirectory(), parameters);
        }
        catch (IOException e) {
            throw new TaskException(this.i18nResolver.getText("aws.codedeploy.task.zipWorkDir.error"), (Throwable)e);
        }
        finally {
            try {
                zipArchiver.close();
            }
            catch (IOException e) {
                throw new TaskException(this.i18nResolver.getText("aws.codedeploy.task.zipWorkDir.error"), (Throwable)e);
            }
        }
        return zipFile;
    }

    @NotNull
    private File generateTempZipFile(@NotNull CommonTaskContext taskContext) throws TaskException {
        String filename = taskContext.getCommonContext().getResultKey().getKey() + "-" + UUID.randomUUID() + ".zip";
        return new File(FileUtils.getTempDirectory(), filename);
    }
}

