/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.aws.codedeploy;

import com.atlassian.aws.ec2.awssdk.AwsSupportConstants;
import com.atlassian.bamboo.configuration.ConfigurationMap;
import com.atlassian.bamboo.plugins.aws.codedeploy.CodeDeployTaskConfigurator;
import com.atlassian.bamboo.task.CommonTaskContext;
import org.jetbrains.annotations.NotNull;

public class CodeDeployConfig {
    private final long credentialsId;
    private final AwsSupportConstants.Region region;
    private final String applicationName;
    private final String s3Bucket;
    private final boolean includeHiddenFiles;
    private final String deploymentGroup;
    private final long deploymentTimeoutInMinutes;

    @NotNull
    public static CodeDeployConfig fromContext(@NotNull CommonTaskContext taskContext) {
        return new CodeDeployConfig(taskContext.getConfigurationMap());
    }

    private CodeDeployConfig(@NotNull ConfigurationMap configurationMap) {
        this.credentialsId = configurationMap.getAsLong(CodeDeployTaskConfigurator.CFG_CREDENTIALS_ID);
        this.region = AwsSupportConstants.Region.valueOf((String)((String)configurationMap.get((Object)CodeDeployTaskConfigurator.CFG_REGION)));
        this.applicationName = (String)configurationMap.get((Object)CodeDeployTaskConfigurator.CFG_APPLICATION_NAME);
        this.s3Bucket = (String)configurationMap.get((Object)CodeDeployTaskConfigurator.CFG_S3_BUCKET);
        this.includeHiddenFiles = configurationMap.getAsBoolean(CodeDeployTaskConfigurator.CFG_INCLUDE_HIDDEN_FILES);
        this.deploymentGroup = (String)configurationMap.get((Object)CodeDeployTaskConfigurator.CFG_DEPLOYMENT_GROUP);
        this.deploymentTimeoutInMinutes = CodeDeployTaskConfigurator.tryParse((String)configurationMap.getOrDefault((Object)CodeDeployTaskConfigurator.CFG_DEPLOY_TIMEOUT_IN_MINUTES, (Object)CodeDeployTaskConfigurator.DEFAULT_DEPLOY_TIMEOUT_IN_MINUTES));
    }

    public long getCredentialsId() {
        return this.credentialsId;
    }

    public AwsSupportConstants.Region getRegion() {
        return this.region;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public String getS3Bucket() {
        return this.s3Bucket;
    }

    public boolean includeHiddenFiles() {
        return this.includeHiddenFiles;
    }

    public String getDeploymentGroup() {
        return this.deploymentGroup;
    }

    public long getDeploymentTimeoutInMinutes() {
        return this.deploymentTimeoutInMinutes;
    }
}

