/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.aws.codedeploy;

import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public enum DeploymentStatus {
    SUCCEEDED("Succeeded"),
    FAILED("Failed"),
    STOPPED("Stopped"),
    CREATED("Created"),
    QUEUED("Queued"),
    INPROGRESS("InProgress"),
    UNKNOWN("Unknown");

    private final String displayName;

    private DeploymentStatus(String displayName) {
        this.displayName = displayName;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public boolean isSuccess() {
        return this == SUCCEEDED;
    }

    public static DeploymentStatus fromDisplayName(@NotNull String displayName) {
        return DeploymentStatus.valueOf(displayName.toUpperCase());
    }

    public static List<DeploymentStatus> valuesFinalisedList() {
        return Arrays.asList(SUCCEEDED, FAILED, STOPPED);
    }
}

