/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.aws.codedeploy;

import com.amazonaws.auth.AWSCredentials;
import com.atlassian.bamboo.collections.ActionParametersMap;
import com.atlassian.bamboo.credentials.ConfigurableSharedCredentialDepender;
import com.atlassian.bamboo.credentials.CredentialsAccessor;
import com.atlassian.bamboo.credentials.CredentialsData;
import com.atlassian.bamboo.plugins.aws.core.AwsException;
import com.atlassian.bamboo.plugins.aws.core.AwsRegion;
import com.atlassian.bamboo.plugins.aws.core.AwsService;
import com.atlassian.bamboo.plugins.aws.core.codedeploy.CodeDeployService;
import com.atlassian.bamboo.plugins.aws.credentials.AwsCredentials;
import com.atlassian.bamboo.plugins.aws.credentials.Constants;
import com.atlassian.bamboo.task.AbstractTaskConfigurator;
import com.atlassian.bamboo.task.TaskDefinition;
import com.atlassian.bamboo.util.BambooStringUtils;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.atlassian.sal.api.message.I18nResolver;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CodeDeployTaskConfigurator
extends AbstractTaskConfigurator
implements ConfigurableSharedCredentialDepender {
    private static final Logger log = Logger.getLogger(CodeDeployTaskConfigurator.class);
    private static final String AWS_CODEDEPLOY_PLUGIN_KEY = "com.atlassian.bamboo.plugins.atlassian-bamboo-plugin-aws-codedeploy";
    public static final String CODE_DEPLOY_TASK_KEY = BambooStringUtils.preventInlining((String)"com.atlassian.bamboo.plugins.atlassian-bamboo-plugin-aws-codedeploy:task.aws.codeDeploy");
    private static final String CFG_AVAILABLE_CREDENTIALS = "availableCredentials";
    private static final String CFG_AVAILABLE_REGIONS = "availableRegions";
    public static final String CFG_CREDENTIALS_ID = BambooStringUtils.preventInlining((String)"credentialsId");
    public static final String CFG_REGION = BambooStringUtils.preventInlining((String)"region");
    public static final String CFG_APPLICATION_NAME = BambooStringUtils.preventInlining((String)"applicationName");
    public static final String CFG_S3_BUCKET = BambooStringUtils.preventInlining((String)"s3Bucket");
    public static final String CFG_DEPLOYMENT_GROUP = BambooStringUtils.preventInlining((String)"deploymentGroup");
    public static final Set<String> FIELD_KEYS = ImmutableSet.builder().add((Object)CFG_CREDENTIALS_ID).add((Object)CFG_REGION).add((Object)CFG_APPLICATION_NAME).add((Object)CFG_S3_BUCKET).add((Object)CFG_DEPLOYMENT_GROUP).add((Object)"workingSubDirectory").build();
    private CodeDeployService codeDeployService;
    private CredentialsAccessor credentialsAccessor;
    private I18nResolver i18nResolver;

    @NotNull
    public Map<String, String> generateTaskConfigMap(@NotNull ActionParametersMap params, @Nullable TaskDefinition previousTaskDefinition) {
        Map map = super.generateTaskConfigMap(params, previousTaskDefinition);
        this.taskConfiguratorHelper.populateTaskConfigMapWithActionParameters(map, params, FIELD_KEYS);
        return map;
    }

    public void populateContextForCreate(@NotNull Map<String, Object> context) {
        super.populateContextForCreate(context);
        this.populateLists(context);
    }

    public void populateContextForEdit(@NotNull Map<String, Object> context, @NotNull TaskDefinition taskDefinition) {
        super.populateContextForEdit(context, taskDefinition);
        context.putAll(taskDefinition.getConfiguration());
        this.populateLists(context);
    }

    public void validate(@NotNull ActionParametersMap params, @NotNull ErrorCollection errorCollection) {
        super.validate(params, errorCollection);
        AwsCredentials credentials = null;
        long credentialsId = params.getLong(CFG_CREDENTIALS_ID, -1L);
        CredentialsData credentialsData = this.credentialsAccessor.getCredentials(credentialsId);
        if (credentialsData == null) {
            errorCollection.addError(CFG_CREDENTIALS_ID, this.i18nResolver.getText("aws.credentials.error.notFound", new Serializable[]{Long.valueOf(credentialsId)}));
        } else {
            credentials = AwsCredentials.fromCredentialsData((CredentialsData)credentialsData);
        }
        if (StringUtils.isBlank((String)params.getString(CFG_REGION))) {
            errorCollection.addError(CFG_REGION, this.i18nResolver.getText("aws.codedeploy.region.empty"));
        } else if (!this.isRegionValid(params.getString(CFG_REGION))) {
            errorCollection.addError(CFG_REGION, this.i18nResolver.getText("aws.codedeploy.region.invalid"));
        } else if (credentials != null) {
            AwsRegion region = AwsRegion.valueOf((String)params.getString(CFG_REGION));
            this.validateCredentials(credentials, region, errorCollection);
        }
        if (StringUtils.isBlank((String)params.getString(CFG_APPLICATION_NAME))) {
            errorCollection.addError(CFG_APPLICATION_NAME, this.i18nResolver.getText("aws.codedeploy.applicationName.empty"));
        }
        if (StringUtils.isBlank((String)params.getString(CFG_S3_BUCKET))) {
            errorCollection.addError(CFG_S3_BUCKET, this.i18nResolver.getText("aws.codedeploy.s3bucket.empty"));
        }
        if (StringUtils.isBlank((String)params.getString(CFG_DEPLOYMENT_GROUP))) {
            errorCollection.addError(CFG_DEPLOYMENT_GROUP, this.i18nResolver.getText("aws.codedeploy.deploymentGroup.empty"));
        }
    }

    @NotNull
    public Iterable<Long> getSharedCredentialIds(@NotNull Map<String, String> config) {
        return ImmutableList.of((Object)Long.valueOf(config.get(CFG_CREDENTIALS_ID)));
    }

    void populateLists(@NotNull Map<String, Object> context) {
        Iterable availableCredentials = this.credentialsAccessor.getAllCredentials(Constants.AWS_CREDENTIALS_TYPE_KEY);
        context.put(CFG_AVAILABLE_CREDENTIALS, Lists.newArrayList((Iterable)availableCredentials));
        context.put(CFG_AVAILABLE_REGIONS, AwsRegion.getRegionsThatSupportService((AwsService)AwsService.CODE_DEPLOY));
    }

    private boolean isRegionValid(String regionString) {
        AwsRegion region;
        try {
            region = AwsRegion.valueOf((String)regionString);
        }
        catch (IllegalArgumentException e) {
            return false;
        }
        return region.isServiceSupported(AwsService.CODE_DEPLOY);
    }

    private void validateCredentials(@NotNull AwsCredentials credentials, @NotNull AwsRegion region, @NotNull ErrorCollection errorCollection) {
        try {
            String error = this.codeDeployService.getAccountValidationError((AWSCredentials)credentials, region);
            if (!StringUtils.isBlank((String)error)) {
                errorCollection.addError(CFG_CREDENTIALS_ID, this.i18nResolver.getText("aws.codedeploy.credentials.invalid", new Serializable[]{region.getDisplayName(), error}));
            }
        }
        catch (AwsException e) {
            log.warn((Object)this.i18nResolver.getText("aws.codedeploy.credentials.error"), (Throwable)e);
            errorCollection.addError(CFG_CREDENTIALS_ID, this.i18nResolver.getText("aws.codedeploy.credentials.error"));
        }
    }

    public void setCodeDeployService(@NotNull CodeDeployService codeDeployService) {
        this.codeDeployService = codeDeployService;
    }

    public void setCredentialsAccessor(@NotNull CredentialsAccessor credentialsAccessor) {
        this.credentialsAccessor = credentialsAccessor;
    }

    public void setI18nResolver(@NotNull I18nResolver i18nResolver) {
        this.i18nResolver = i18nResolver;
    }
}

