/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.util;

import com.atlassian.bamboo.variable.VariableDefinition;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.collect.Collections2;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PasswordMaskingUtils {
    public static final String PASSWORD_MASK = "********";
    private static final Function<VariableDefinition, ? extends VariableDefinition> MASK_VARIABLE_IF_NEEDED = new Function<VariableDefinition, VariableDefinition>(){

        public VariableDefinition apply(VariableDefinition input) {
            if (PasswordMaskingUtils.shouldBeMasked(input)) {
                input.setValue(PasswordMaskingUtils.PASSWORD_MASK);
                input.setId(-input.getId());
            }
            return input;
        }
    };

    private PasswordMaskingUtils() {
    }

    public static boolean isMasked(@Nullable String value) {
        return PASSWORD_MASK.equals(value);
    }

    public static boolean shouldBeMasked(@Nullable String variableName) {
        return StringUtils.containsIgnoreCase((String)variableName, (String)"password");
    }

    public static boolean shouldBeMasked(@NotNull VariableDefinition variableDefinition) {
        return PasswordMaskingUtils.shouldBeMasked(variableDefinition.getKey());
    }

    public static boolean shouldIgnoreValue(String key, String value) {
        return PasswordMaskingUtils.shouldBeMasked(key) && PasswordMaskingUtils.isMasked(value);
    }

    public static Collection<? extends VariableDefinition> maskPasswordValues(@NotNull List<VariableDefinition> variables, @NotNull Function<VariableDefinition, ? extends VariableDefinition> clone) {
        return Collections2.transform(variables, (Function)Functions.compose(MASK_VARIABLE_IF_NEEDED, clone));
    }

    @NotNull
    public static String mask(@NotNull String string, @Nullable String password) {
        if (StringUtils.isEmpty((String)password)) {
            return string;
        }
        return string.replace(password, PASSWORD_MASK);
    }
}

