/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.util;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Splitter;
import java.util.Collection;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.CharUtils;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BambooStringUtils {
    private static final Logger log = Logger.getLogger(BambooStringUtils.class);
    private static final Pattern INVALID_CHARACTERS_REGEX = Pattern.compile("[^-A-Za-z0-9_:.]");
    public static final char CHAR_NONE = '\u0000';
    public static final char CHAR_APOSTROPHE = '\'';
    public static final char CHAR_BACKSLASH = '\\';
    public static final char CHAR_DOUBLE_QUOTE = '\"';
    public static final char CHAR_ELLIPSIS = '\u2026';
    public static final char[] XSS_RELATED_CHARACTERS = new char[]{'\"', '&', '\'', '<', '>', '\\'};
    public static final String XSS_RELATED_CHARACTERS_FIND_STR = "'\"\\\\<\\>";
    private static final char[] RELAXED_XSS_RELATED_CHARACTERS = new char[]{'\"', '&', '\'', '<', '>'};
    private static final Pattern HREF_PATTERN = Pattern.compile("a\\s+href\\s*=\\s*\"([\\w\\$\\-\\+\\(\\):/\\.!\\?#=]*(&[a-zA-Z])*)*\"(\\s+rel\\s*=\\s*\"[\\w]*\")*\\s*");
    private static final Pattern htmlWhiteListPattern = Pattern.compile("(/?+ *(p|i|b|div) *)|(/ *a *)|( *br */?+)");
    private static final Function<String, String> STRIP_FULLY_ENCLOSING_QUOTES = new Function<String, String>(){
        final Pattern FULLY_ENCLOSED_IN_DOUBLE_QUOTES = Pattern.compile("\"(.*)\"");
        final Pattern FULLY_ENCLOSED_IN_SINGLE_QUOTES = Pattern.compile("'(.*)'");

        public String apply(@Nullable String input) {
            Matcher matcher = this.FULLY_ENCLOSED_IN_DOUBLE_QUOTES.matcher(input);
            if (matcher.matches()) {
                input = matcher.group(1);
            } else {
                matcher = this.FULLY_ENCLOSED_IN_SINGLE_QUOTES.matcher(input);
                if (matcher.matches()) {
                    input = matcher.group(1);
                }
            }
            return input;
        }
    };

    private BambooStringUtils() {
    }

    @NotNull
    public static String forceAlphaNumeric(@Nullable String str) {
        if (str == null) {
            return "";
        }
        char[] charArray = str.toCharArray();
        StringBuffer sBuf = new StringBuffer();
        for (char aChar : charArray) {
            if (!CharUtils.isAsciiAlphanumeric((char)aChar)) continue;
            sBuf.append(aChar);
        }
        return sBuf.toString();
    }

    public static boolean containsXssRelatedCharacters(@Nullable String string) {
        return BambooStringUtils.containsDefinedXssRelatedCharacters(string, XSS_RELATED_CHARACTERS);
    }

    @NotNull
    public static String getFirstXssRelatedCharacter(@Nullable String string) {
        return BambooStringUtils.getFirstDefinedXssRelatedCharacter(string, XSS_RELATED_CHARACTERS);
    }

    public static boolean containsRelaxedXssRelatedCharacters(@Nullable String string) {
        return BambooStringUtils.containsDefinedXssRelatedCharacters(string, RELAXED_XSS_RELATED_CHARACTERS);
    }

    @NotNull
    public static String getFirstRelaxedXssRelatedCharacter(@Nullable String string) {
        return BambooStringUtils.getFirstDefinedXssRelatedCharacter(string, RELAXED_XSS_RELATED_CHARACTERS);
    }

    public static boolean containsDefinedXssRelatedCharacters(@Nullable String string, @NotNull char[] characters) {
        return string != null && StringUtils.containsAny((String)string, (char[])characters);
    }

    @NotNull
    public static String getFirstDefinedXssRelatedCharacter(@Nullable String string, @NotNull char[] characters) {
        if (string == null) {
            return "";
        }
        int unsafeCharIndex = StringUtils.indexOfAny((String)string, (char[])characters);
        if (unsafeCharIndex == -1) {
            return "";
        }
        return string.substring(unsafeCharIndex, unsafeCharIndex + 1);
    }

    @NotNull
    public static String forceValidHtmlId(@NotNull String id) {
        return INVALID_CHARACTERS_REGEX.matcher(id).replaceAll("_");
    }

    public static Iterable<String> lineIterator(String string) {
        return Splitter.onPattern((String)"\r?\n").split((CharSequence)string);
    }

    public static Predicate<String> containsString(final @NotNull String string) {
        return new Predicate<String>(){

            public boolean apply(String input) {
                return input.contains(string);
            }
        };
    }

    public static int indexOf(String haystack, String needle, int n) {
        Pattern compile = Pattern.compile(needle, 16);
        return BambooStringUtils.indexOf(haystack, n, compile);
    }

    public static int indexOfRegex(String haystack, String needle, int occurence) {
        Pattern compile = Pattern.compile(needle);
        return BambooStringUtils.indexOf(haystack, occurence, compile);
    }

    private static int indexOf(String string, int occurence, Pattern compile) {
        Matcher matcher = compile.matcher(string);
        while (matcher.find()) {
            if (occurence <= 0) {
                return matcher.start();
            }
            --occurence;
        }
        return -1;
    }

    public static boolean startsWithAny(String string, Collection<String> searchStrings) {
        return StringUtils.startsWithAny((String)string, (String[])searchStrings.toArray(new String[searchStrings.size()]));
    }

    public static String encodeHtmlWithTagWhiteList(String string) {
        StringTokenizer st = new StringTokenizer(string, "<>", true);
        StringBuilder sb = new StringBuilder();
        String tagContent = null;
        EncoderState state = EncoderState.START;
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            switch (state) {
                case START: {
                    if (token.equals("<")) {
                        state = EncoderState.AFTER_LT;
                        break;
                    }
                    sb.append(StringEscapeUtils.escapeHtml((String)token));
                    break;
                }
                case AFTER_LT: {
                    if (token.equals("<")) {
                        sb.append(StringEscapeUtils.escapeHtml((String)"<"));
                        break;
                    }
                    if (token.equals(">")) {
                        sb.append(StringEscapeUtils.escapeHtml((String)">"));
                        state = EncoderState.START;
                        break;
                    }
                    tagContent = token;
                    state = EncoderState.AFTER_TAG_CONTENT;
                    break;
                }
                case AFTER_TAG_CONTENT: {
                    if (token.equals(">") && htmlWhiteListPattern.matcher(tagContent).matches()) {
                        sb.append("<").append(tagContent).append(">");
                        state = EncoderState.START;
                        break;
                    }
                    if (token.equals(">") && tagContent.startsWith("a ")) {
                        sb.append(BambooStringUtils.sanitizeLink(tagContent));
                        state = EncoderState.START;
                        break;
                    }
                    if (token.equals("<")) {
                        sb.append(StringEscapeUtils.escapeHtml((String)"<"));
                        sb.append(StringEscapeUtils.escapeHtml((String)tagContent));
                        state = EncoderState.AFTER_LT;
                        break;
                    }
                    sb.append(StringEscapeUtils.escapeHtml((String)"<"));
                    sb.append(StringEscapeUtils.escapeHtml((String)tagContent));
                    sb.append(StringEscapeUtils.escapeHtml((String)token));
                    state = EncoderState.START;
                }
            }
        }
        switch (state) {
            case START: {
                break;
            }
            case AFTER_LT: {
                sb.append(StringEscapeUtils.escapeHtml((String)"<"));
                break;
            }
            case AFTER_TAG_CONTENT: {
                sb.append(StringEscapeUtils.escapeHtml((String)"<"));
                sb.append(StringEscapeUtils.escapeHtml(tagContent));
            }
        }
        return sb.toString();
    }

    public static Function<String, String> encodeHtmlWithTagWhiteListFunction() {
        return new Function<String, String>(){

            public String apply(String from) {
                return BambooStringUtils.encodeHtmlWithTagWhiteList(from);
            }
        };
    }

    @NotNull
    public static String unquote(@NotNull String quotedVarValue, boolean processBackslashes) {
        char[] unquoted = new char[quotedVarValue.length()];
        int ui = 0;
        char quotedBy = '\u0000';
        boolean backslash = false;
        for (int i = 0; i < quotedVarValue.length(); ++i) {
            char lookingAt = quotedVarValue.charAt(i);
            if (backslash) {
                unquoted[ui++] = lookingAt;
                backslash = false;
                continue;
            }
            if (quotedBy != '\'' && lookingAt == '\\' && processBackslashes) {
                backslash = true;
                continue;
            }
            if (quotedBy == '\u0000' && BambooStringUtils.in(lookingAt, '\"', '\'')) {
                quotedBy = lookingAt;
                continue;
            }
            if (lookingAt == quotedBy) {
                quotedBy = '\u0000';
                continue;
            }
            unquoted[ui++] = lookingAt;
        }
        return new String(unquoted, 0, ui);
    }

    private static boolean in(char needle, char ... haystack) {
        for (char c : haystack) {
            if (needle != c) continue;
            return true;
        }
        return false;
    }

    public static boolean in(String needle, String ... haystacks) {
        for (String haystack : haystacks) {
            if (!needle.equals(haystack)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public static String remove(@NotNull String quotedVarValue, int index) {
        if (index == -1) {
            return quotedVarValue;
        }
        String firstPart = quotedVarValue.substring(0, index);
        if (index == quotedVarValue.length()) {
            return firstPart;
        }
        return firstPart + quotedVarValue.substring(index + 1);
    }

    @Nullable
    public static String truncateAndAddEllipsis(@Nullable String string, int maxLength) {
        if (string != null && string.length() > maxLength) {
            return StringUtils.left((String)string, (int)(maxLength - 1)) + '\u2026';
        }
        return string;
    }

    private static String sanitizeLink(String string) {
        if (HREF_PATTERN.matcher(string).matches()) {
            return "<" + string + ">";
        }
        return StringEscapeUtils.escapeHtml((String)"<") + StringEscapeUtils.escapeHtml((String)string) + StringEscapeUtils.escapeHtml((String)">");
    }

    public static Function<String, String> stripFullyEnclosingQuotes() {
        return STRIP_FULLY_ENCLOSING_QUOTES;
    }

    @NotNull
    public static String dos2unix(@NotNull String s) {
        return s.replaceAll("\r\n", "\n");
    }

    public static String toCamelCase(@NotNull String string, char separator) {
        StringBuffer camelCase = new StringBuffer();
        for (String word : Splitter.on((char)separator).omitEmptyStrings().split((CharSequence)string)) {
            if (camelCase.length() != 0) {
                camelCase.append(StringUtils.capitalize((String)word));
                continue;
            }
            camelCase.append(StringUtils.uncapitalize((String)word));
        }
        return camelCase.toString();
    }

    public static String toCommandLineString(@NotNull Iterable<String> commandArgs) {
        StringBuilder sb = new StringBuilder();
        Iterator<String> commandArgsIterator = commandArgs.iterator();
        while (commandArgsIterator.hasNext()) {
            String commandArg = commandArgsIterator.next();
            if (commandArg.contains(" ")) {
                sb.append('\'').append(commandArg).append('\'');
            } else {
                sb.append(commandArg);
            }
            if (!commandArgsIterator.hasNext()) continue;
            sb.append(" ");
        }
        return sb.toString();
    }

    static enum EncoderState {
        START,
        AFTER_LT,
        AFTER_TAG_CONTENT;

    }
}

