/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.repository;

import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.Collection;

public interface CacheDescription {
    public String getKey();

    public String getLocation();

    public String getDescription();

    public boolean isExists();

    public Collection<ImmutablePlan> getUsingPlans();

    public static class FileBased
    implements CacheDescription {
        private final String key;
        private final String location;
        private final String description;
        private final boolean exists;
        private final Collection<ImmutablePlan> usingPlans;

        public FileBased(File cacheDir, String description, Collection<ImmutablePlan> plans) {
            this.key = cacheDir.getName();
            this.location = cacheDir.getAbsolutePath();
            this.description = description;
            this.exists = cacheDir.exists();
            this.usingPlans = Lists.newArrayList(plans);
        }

        @Override
        public String getKey() {
            return this.key;
        }

        @Override
        public String getLocation() {
            return this.location;
        }

        @Override
        public String getDescription() {
            return this.description;
        }

        @Override
        public boolean isExists() {
            return this.exists;
        }

        @Override
        public Collection<ImmutablePlan> getUsingPlans() {
            return this.usingPlans;
        }
    }
}

