/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.chains.branches;

import com.google.common.collect.ImmutableMap;
import java.util.Map;

public enum BranchNotificationStrategy {
    NOTIFY_COMMITTERS("notifyCommitters"),
    INHERIT("inherit"),
    NONE("none");

    private final String key;
    private static Map<String, BranchNotificationStrategy> key2Bns;

    private BranchNotificationStrategy(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public static BranchNotificationStrategy fromKey(String key) {
        if (key2Bns.containsKey(key)) {
            return key2Bns.get(key);
        }
        throw new IllegalArgumentException(key + " is not BranchNotificationStrategy");
    }

    static {
        key2Bns = ImmutableMap.of((Object)NOTIFY_COMMITTERS.getKey(), (Object)((Object)NOTIFY_COMMITTERS), (Object)INHERIT.getKey(), (Object)((Object)INHERIT), (Object)NONE.getKey(), (Object)((Object)NONE));
    }
}

