/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.failurecache;

import com.atlassian.failurecache.Cache;
import com.atlassian.failurecache.CacheFactory;
import com.atlassian.failurecache.CacheLoader;
import com.atlassian.failurecache.Cacheable;
import com.atlassian.failurecache.EagerCacheUpdatePolicy;
import com.atlassian.failurecache.ExpirationDateBasedCacheImpl;
import com.atlassian.failurecache.failures.ExponentialBackOffFailureCache;
import com.atlassian.failurecache.util.date.Clock;
import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.Set;
import java.util.WeakHashMap;

class CacheFactoryImpl
implements CacheFactory,
Cacheable {
    private final Clock clock;
    private final Set<Cacheable> failureCacheSet;
    private final Set<Cache> valueCacheSet;

    public CacheFactoryImpl(Clock clock) {
        this.clock = (Clock)Preconditions.checkNotNull((Object)clock);
        this.failureCacheSet = Collections.newSetFromMap(new WeakHashMap());
        this.valueCacheSet = Collections.newSetFromMap(new WeakHashMap());
    }

    @Override
    public <K, V> Cache<V> createExpirationDateBasedCache(CacheLoader<K, V> cacheLoader) {
        Preconditions.checkNotNull(cacheLoader, (Object)"cacheLoader");
        ExponentialBackOffFailureCache failureCache = new ExponentialBackOffFailureCache(this.clock);
        this.failureCacheSet.add(failureCache);
        ExpirationDateBasedCacheImpl<K, V> cache = new ExpirationDateBasedCacheImpl<K, V>(cacheLoader, new EagerCacheUpdatePolicy(this.clock, failureCache));
        this.valueCacheSet.add(cache);
        return cache;
    }

    @Override
    public int getCachePriority() {
        if (this.failureCacheSet.isEmpty()) {
            return 200;
        }
        return this.failureCacheSet.iterator().next().getCachePriority();
    }

    @Override
    public void clearCache() {
        for (Cacheable failureCache : this.failureCacheSet) {
            failureCache.clearCache();
        }
        for (Cache cache : this.valueCacheSet) {
            cache.clear();
        }
    }
}

