package com.atlassian.applinks.api.oauth2;

import com.atlassian.applinks.api.ApplicationLink;

/**
 * Methods to retrieve data from the Atlassian OAuth2 client plugin
 * to use within Application Links.
 *
 * @since 8.0.11
 */
public interface ApplinkOAuth2Service {

    /**
     * Fetches all the oauth2 client configurations as application links.
     *
     * Modifications to the returned objects will not apply any changes
     * to the original oauth2 client configurations.
     *
     * @return an {@link Iterable} of {@link ApplicationLink}s; one for each client.
     * @since 8.1
     */
    Iterable<ApplicationLink> getApplicationLinksForOAuth2Clients();

    /**
     * Fetches all the oauth2 provider configurations as application links.
     *
     * Modifications to the returned objects will not apply any changes
     * to the original oauth2 provider configurations.
     *
     * @return an {@link Iterable} of {@link ApplicationLink}s; one for each provider.
     * @since 8.1
     */
    Iterable<ApplicationLink> getApplicationLinksForOAuth2Provider();
}
