package com.atlassian.applinks.api;

/**
 * Indicates the origin of an application link.
 * Used by links that come from the Atlassian OAuth2 plugin.
 *
 * @since 8.0.11
 */
public enum OAuth2ConnectionType {

    /**
     * This connection type is given to all application links
     * that represent a connection from the OAuth2 client plugin.
     *
     * @since 8.1
     */
    OAUTH2_CLIENT,

    /**
     * This connection type is given to all application links
     * that represent a connection from the OAuth2 provider plugin.
     *
     * @since 8.1
     */
    OAUTH2_PROVIDER
}
