package com.atlassian.annotations.security;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * Permits resource access ONLY to users assigned a product license
 * (see {@code com.atlassian.sal.api.user.UserManager#isLicensed}).
 *
 * @since 5.0.0
 */
@Target({ElementType.TYPE, ElementType.METHOD})
@Retention(RetentionPolicy.RUNTIME)
public @interface LicensedOnly {}
