package com.atlassian.annotations.security;

import com.atlassian.annotations.ExperimentalApi;

import java.lang.annotation.*;

/**
 * The annotated element is excluded from
 * Cross-site request forgery (CSRF/XSRF) protection.
 * <p>
 * This element is designed for products and plugins to
 * <em>exclude</em> resource methods from XSRF protection.
 * </p>
 */
@Documented
@Retention(RetentionPolicy.RUNTIME)
@Target(value = ElementType.METHOD)
@ExperimentalApi
public @interface XsrfProtectionExcluded
{
}
