package com.atlassian.analytics.client.serialize;

import com.atlassian.util.concurrent.LazyReference;

/**
 * This is a temporary measure to check if the MauEvent class is available without actually
 * loading the class definition (which would cause a ClassNotFoundException) in client code.
 *
 * Until all products have upgraded to the analytics-api v4.3.0 this code will have to exist.
 *
 * @since v4.3
 */
public class IsMauEventAvailable extends LazyReference<Boolean> {
    @Override
    protected Boolean create() throws Exception {
        try {
            Thread.currentThread().getContextClassLoader().loadClass("com.atlassian.analytics.api.events.MauEvent");
            return true;
        } catch (ClassNotFoundException ignored) {
        }
        return false;
    }
}
