package com.atlassian.analytics.client.logger;

import com.atlassian.analytics.client.AnalyticsMd5Hasher;
import com.atlassian.analytics.client.uuid.ProductUUIDProvider;

/**
 * Responsible for hashing event properties to anonymize the data.
 */
public class EventAnonymizer
{
    private final ProductUUIDProvider productUUIDProvider;

    public EventAnonymizer(final ProductUUIDProvider productUUIDProvider)
    {
        this.productUUIDProvider = productUUIDProvider;
    }

    public String hash(final String data)
    {
        return AnalyticsMd5Hasher.md5Hex(data, productUUIDProvider.getUUID().toString());
    }

    public String hashEventProperty(final String propertyValue)
    {
        return propertyValue != null ? hash(propertyValue) : null;
    }
}
