package com.atlassian.analytics.client.hash;

/**
 * Provides a hashing function for securely hashing a user's e-mail address.  Implementations
 * need to be secure enough to make brute-forcing hashes significantly expensive given the limited
 * amount of entropy available when dealing with e-mail addresses.
 * <p>
 * See https://extranet.atlassian.com/x/3h85m for more details.
 *
 * @since v4.3
 */
public interface AnalyticsEmailHasher {

    /**
     * Given an e-mail address this method provides a secure hash including the hashing instructions used.
     * <p>
     * E-mail addresses will also be sanitized using the {@link EmailCleaner#cleanEmail(String)} method.
     *
     * @param email a valid e-mail address
     * @return a secure hash of the e-mail. May be null if hashing was unsuccessful
     */
    String hash(String email);

    /**
     * Reads and stores remote hashing instructions using {@link com.atlassian.analytics.client.hash.reader.RemoteHashingInstructionsReader}
     */
    void readRemoteInstructions();
}
